
/*
 * @Author: sunbingqing
 * @Date: 2019-08-05 11:05:00
 * @Last Modified by: zhujian
 * @Last Modified time: 2020-05-26 19:50:20
 */

import React from 'react';
import { Spin, Select } from 'antd';
import _ from 'underscore';

import Service from '@/common/js/service';

class ClassSearchSelect extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      query: {
        size: 10,
        current: 1,
        classNameLike: null,
        status: ['INIT', 'STUDYING', 'END'],
      },
      dataSet: [],
      isAll: false
    }
  }

  componentWillMount() {
    this.handleFetchClassList();
  }

  handleFetchClassList = (current = 1) => {
    const { courseId } = this.props;
    const _query = _.clone(this.state.query);
    _query.courseId = courseId;
    _query.current = current;

    Service.Business('public/class/digestList', _query)
      .then((res) => {
        const { result = {} } = res || {};
        const { records = [], hasNext = false } = result;

          _.map(records, (item) => {
            item.formatName = item.name;
            return item;
          });

          this.setState({
            isAll: !hasNext,
            dataSet: current === 1 ? records : [...this.state.data, ...records]
          });
      })
  }

  handleClassSelect = (classId) => {
    const { query } = this.state;
    if (query.classNameLike) {
      query.classNameLike = null;
      this.setState({ query }, this.handleFetchClassList);
    }
    
    this.props.onSelect(classId);
  }

  handleFetchMore = (e) => {
    const { isAll } = this.state;
    const ulDom = e.currentTarget.getElementsByTagName("ul")[0];
    if (ulDom.length <= 0) return;
    
    const { scrollTop, clientHeight, scrollHeight } = ulDom;
    if (scrollTop + clientHeight > scrollHeight - 30 && !isAll) {
      this.handleFetchClassList();
    }
  }

  render() {
    const { label, defaultValue, placeholder } = this.props;
    const { query, isAll, dataSet } = this.state;

    return (
      <div className={"common-select staticSelect"}>
      {
        !!label && <div className='label'> {label}:</div>
      }
      <Select
        showSearch
        allowClear
        onSearch={(value) => {
          query.classNameLike = value;
          this.setState({ query }, this.handleFetchClassList)
        }}
        onPopupScroll={this.handleFetchMore}
        placeholder={placeholder}
        value={defaultValue}
        onChange={this.handleClassSelect}
        filterOption={(input, option) => option}
      >
        {
          _.map(dataSet, (item, index) => {
            return (
              <Select.Option
                id={`class_select_item_${index}` }
                key={item.classId}
                value={item.classId}
                title={item.name}
              >
                {item.name}
              </Select.Option>
            );
          })
        }
        {!isAll &&
          <Select.Option
            disabled 
            tyle={{ textAlign: 'center' }}
            value="spin"
          >
            <Spin size="small" />
          </Select.Option>
        }
      </Select>
    </div>
    )
  }
}

export default ClassSearchSelect;
