/*
 * @Author: sunbingqing
 * @Date: 2019-07-26 11:26:00
 * @Last Modified by: 孙冰清
 * @Last Modified time: 2019-07-26 11:59:24
 */

import React from 'react';
import { Breadcrumb } from 'antd';
import { LeftOutlined } from '@ant-design/icons';
import _ from 'underscore';
import './Breadcrumbs.less';

interface BreadcrumbsProps {
  goBack?: () => void;
  navList: string | string[];
  text?: string;
}

const Breadcrumbs = (props: BreadcrumbsProps) => {
  const { goBack, navList, text } = props;
  
  function _onClick(): any {
    console.log("返回来")
    goBack ? goBack() : window.RCHistory.goBack();
  }
  const isString = _.isString(navList);
  const isArray = _.isArray(navList);
  return (
    <div className="xm-breadCrumb">
      <span onClick={_onClick} className="back-btn" />
      <LeftOutlined/>
      <span className="text ml5" >{text ? text : '返回'}</span>
      <div className="divide"></div>
      <Breadcrumb>
        {isString && <Breadcrumb.Item>{navList}</Breadcrumb.Item>}
        {isArray && _.map(navList, (item: string, index: number) => {
          return <Breadcrumb.Item key={index}>{item}</Breadcrumb.Item>;
        })}
        { !isString && !isArray && <Breadcrumb.Item>{navList}</Breadcrumb.Item>}
      </Breadcrumb>
    </div>
  );
};

export default Breadcrumbs;
