import React from "react";
import { withRouter } from "react-router-dom";
import {
  Input,
  InputNumber,
  Table,
  Tooltip,
  Popover,
  Select,
  message,
  Modal,
  Button,
  Popconfirm,
  Spin,
  Checkbox,
} from "antd";
import dealTimeDuration from "../utils/dealTimeDuration";
import { PageControl } from "@/components";
import SelectStudent from "../modal/select-student";
// import { StudentStatus } from '@/modules/types';
import Bus from "@/core/bus";
import StudentClassReportModal from "../components/StudentClassReportModal";
import TeacherClassReportModal from "../components/TeacherClassReportModal";

import "./DataList.less";
const { TextArea } = Input;
const { Search } = Input;
const ConsumeHourTypeEnum = {
  SUPER_NOT_CONSUME: "超上未扣",
  MANUAL_CONSUME: "手动扣除",
  ARRIVE_CONSUME: "到课扣除",
};
const StudentStatus = {};
class DataList extends React.Component {
  constructor(props) {
    super(props);
    const courseId = getParameterByName("id"); // 课程ID
    const type = getParameterByName("type"); // 来源: 大班直播 large 互动班课 interactive
    const instId = window.currentUserInstInfo.instId || LS.get("instId"); // 机构ID
    console.log("course-data");
    this.state = {
      courseId,
      type,
      instId,
      teacherData: [], // 老师上课数据
      studentData: [], // 学员上课数据
      courseInfo: {}, // 课程信息
      liveSignState: "",
      nameOrPhone: "", // 搜索学员姓名/手机号
      currentEditData: {}, // 当前编辑对象
      current: 1,
      size: 1000, // 添加扣课时学员弹窗回填所需 当前接口返回全部列表
      total: 0,
      loading: false,
      teacherClassReportModal: null, // 展示老师课堂报告
      studentClassReportModal: null, // 展示学生课堂报告
      hasOpenIntegral: false, // 是否开启小麦粒积分
      excludeStudentIds: [],
      excludeConsumeStudentIds: [],
    };
  }

  componentDidMount() {
    // this.fetchCourseInfo();
    // this.fetchTeacherData();
    // this.fetchStudentData();
    // this.getXMPointConfig();
  }

  // 获取小麦粒配置
  getXMPointConfig() {
    // axios.Business("public/integral/getConfig").then(res => {
    //   this.setState({
    //     hasOpenIntegral: res.result
    //   })
    // })
  }

  // 获取课程信息
  fetchCourseInfo() {
    // axios
    //   .Apollo('public/businessLive/getCourseDetail', {
    //     liveCourseId: this.state.courseId,
    //   })
    //   .then((res) => {
    //     const { result = {} } = res;
    //     const courseInfo = result;
    //     this.setState({
    //       courseInfo,
    //     });
    //   });
  }
  // 获取学员上课数据
  fetchStudentData = (current = 1) => {
    this.setState({ loading: true });
    const { courseId, size, nameOrPhone, liveSignState } = this.state;
    const params = {
      liveCourseId: courseId,
      current,
      size,
      nameOrPhone,
      liveSignState,
    };
    if (!params.liveSignState) {
      delete params.liveSignState;
    }
    // window.axios
    //   .Apollo("public/businessLive/queryStudentVisitData", params)
    //   .then((res) => {
    //     if (res.result) {
    //       const { records = [], current, size, total } = res.result;
    //       records.forEach(item => {
    //         item.edit = false;
    //         item.courseBag = [];
    //       });
    //       this.setState({
    //         studentData: records,
    //         current,
    //         size,
    //         total,
    //         loading: false,
    //       }
    //     );
    //   }
    // });
  };
  // 获取老师上课数据
  fetchTeacherData = () => {
    // window.axios
    //   .Apollo('public/businessLive/queryTeacherVisitData', { liveCourseId: this.state.courseId })
    //   .then((res) => {
    //     if (res.result) {
    //       const teacherData = [res.result];
    //       this.setState(
    //         {
    //           teacherData,
    //         }
    //       );
    //     }
    //   });
  };
  // 添加上课学员弹窗
  handleShowSelectStuModal = (studentType) => {
    const { studentData } = this.state;
    const { courseId, courseInfo, savedSelectedRows } = this.state;
    const [
      studentList,
      consumeStudentList,
      excludeStudentIds,
      excludeConsumeStudentIds,
    ] = [[], [], [], []];
    studentData.forEach((item) => {
      if (item.statusEnum === "NORMAL") {
        if (item.needConsumeHour === "YES") {
          consumeStudentList.push({
            studentId: item.userId,
            classHourId: item.consumeHourClassId,
          });
          excludeConsumeStudentIds.push(item.userId);
        } else if (item.needConsumeHour === "NO") {
          studentList.push({ studentId: item.userId });
          excludeStudentIds.push(item.userId);
        }
        this.setState({
          excludeStudentIds,
          excludeConsumeStudentIds,
        });
      }
    });

    const studentModal = (
      <SelectStudent
        savedSelectedRows={savedSelectedRows}
        liveCourseId={courseId}
        studentType={studentType}
        studentList={studentList}
        consumeStudentList={consumeStudentList}
        excludeStudentIds={excludeStudentIds}
        excludeConsumeStudentIds={excludeConsumeStudentIds}
        onSelect={(
          excludeStudentIds,
          consumeStudentList,
          savedSelectedRows
        ) => {
          this.setState({ savedSelectedRows });
          this.handleSelectStudent(
            courseInfo,
            excludeStudentIds,
            consumeStudentList,
            studentType
          );
        }}
        after={true}
        close={() => {
          this.setState({
            studentModal: null,
          });
        }}
      />
    );
    this.setState({ studentModal });
  };

  // 添加学员
  handleSelectStudent = (item, studentIds, consumeStudentList, studentType) => {
    const { liveType, liveCourseId, podium, quota } = item;
    const {
      excludeStudentIds = [],
      excludeConsumeStudentIds = [],
    } = this.state;
    // 当前选择的学员
    const currentSelectStuIds =
      studentType === "DEDUCTION"
        ? _.pluck(consumeStudentList, "studentId")
        : studentIds;
    // 如果当前选择的是扣课时学员，那么总的已选学员人数 = 扣课时 + 之前选择不扣课时的
    // 如果当前选择的是不扣课时学员，那么总的已选学员人数 = 不扣课时 + 之前选择的扣课时的
    const prevSelectStutIds =
      studentType === "DEDUCTION"
        ? excludeStudentIds
        : excludeConsumeStudentIds;

    const stuLen = [...currentSelectStuIds, ...prevSelectStutIds].length;

    if (liveType !== "SMALL_CLASS_INTERACTION" && stuLen > 1000) {
      message.info(`最多选择1000人`);
      return;
    } else if (liveType == "SMALL_CLASS_INTERACTION" && stuLen > podium) {
      message.info(`最多选择${podium}人`);
      return;
    } else {
      const param = {
        liveCourseId: liveCourseId,
      };
      if (studentType === "DEDUCTION") {
        param.consumeStudentIds = consumeStudentList;
      } else {
        param.studentIds = studentIds;
      }
      // axios.Apollo('public/businessLive/addCourseStu', param).then((res) => {
      //   if (res.success) {
      //     this.setState({
      //       studentModal: null,
      //     });
      //     message.success('学员变更成功');
      //     this.fetchStudentData();
      //   }
      // });
    }
  };
  // 移出学员
  handelDeleteStu(item) {
    const { courseId } = this.state;
    const { userId, innerLiveUserId } = item;
    const params = {
      innerLiveUserId: innerLiveUserId,
      liveCourseId: courseId,
      studentId: userId,
    };
    // axios.Apollo('/public/businessLive/moveCourseStu', params).then((res) => {
    //   if (res.success === true) {
    //     message.success('移出成功');
    //     this.fetchStudentData();
    //   }
    // });
  }
  // 获取课程包
  fetchCourseBag(item, index) {
    const params = {
      studentId: item.userId,
    };
    const { studentData } = this.state;
    // axios.Business('public/classHour/getUseAbleAccountByStudentId', params).then((res) => {
    //   const { success, result } = res;
    //   if (success) {
    //     studentData[index] = {
    //       ...studentData[index],
    //       courseBag: result || [],
    //     };
    //     let currentEditData = JSON.parse(JSON.stringify(studentData[index]));
    //     this.setState({
    //       studentData,
    //       currentEditData,
    //     });
    //   }
    // });
  }
  // 编辑
  handelEditColumn(item, index) {
    this.fetchCourseBag(item, index);
    const { studentData } = this.state;

    studentData.forEach((i, y) => {
      if (y === index) {
        i.edit = true;
      } else {
        i.edit = false;
      }
    });
    let currentEditData = JSON.parse(JSON.stringify(studentData[index]));
    this.setState({
      studentData,
      currentEditData,
    });
  }
  // 保存
  handelSaveColumn(index) {
    const { instId, currentEditData } = this.state;
    const consumeUserId = window.currentUserInstInfo.adminId;
    const {
      consumeHourClassId,
      consumeHourNum,
      remark,
      liveStudentId,
    } = currentEditData;
    const params = {
      consumeHourClassId: consumeHourClassId,
      consumeHourNum,
      remark,
      consumeUserId: consumeUserId,
      instId: instId,
      liveStudentId: liveStudentId,
    };
    // axios.Apollo('public/businessLive/updateStudentVisitCheckedData', params).then((res) => {
    //   if (res.success === true) {
    //     message.success('修改成功');
    //     this.fetchStudentData();
    //   }
    // });
  }
  // 取消
  handelCancelColumn(index) {
    const { studentData } = this.state;
    studentData[index].edit = false;
    this.setState({
      studentData,
    });
  }
  // 修改
  changeFiledValue(filed, val, index) {
    const { currentEditData } = this.state;
    currentEditData[filed] = val;
    this.setState({
      currentEditData,
    });
  }
  // 修改课程包
  handleChangeCourse(val, index) {
    let { currentEditData } = this.state;
    const courseObj = currentEditData.courseBag.find((item) => {
      if (item.courseId === val) {
        return item;
      }
    });
    const { courseName, leftLessons } = courseObj;
    currentEditData = {
      ...currentEditData,
      consumeHourClassId: val,
      consumeHourClassName: courseName,
      leftLessons,
    };
    this.setState({
      currentEditData,
    });
  }
  // 进入直播次数列表
  getVisiterColumns() {
    const columns = [
      {
        title: "序号",
        dataIndex: "index",
        width: 50,
        render: (text, record, index) => {
          return <span>{index + 1}</span>;
        },
      },
      {
        title: "进入时间",
        dataIndex: "entryTime",
        width: 150,
        render: (text) => (
          <span>{formatDate("YYYY-MM-DD H:i", parseInt(text))}</span>
        ),
      },
      {
        title: "离开时间",
        dataIndex: "leaveTime",
        width: 150,
        render: (text) => (
          <span>{formatDate("YYYY-MM-DD H:i", parseInt(text))}</span>
        ),
      },
      {
        title: "在线时长",
        dataIndex: "lookingDuration",
        render: (text, record) => {
          return <span>{text ? dealTimeDuration(text) : "-"}</span>;
        },
      },
    ];
    return columns;
  }

  // 查看老师课堂报告
  handleCheckTeacherClassReport = () => {
    const teacherClassReportModal = (
      <TeacherClassReportModal
        courseId={this.state.courseInfo.liveCourseId}
        onCancel={() => {
          this.setState({ teacherClassReportModal: null });
        }}
      />
    );
    this.setState({
      teacherClassReportModal,
    });
  };

  // 查看学生课堂报告
  handleCheckStudentClassReport = (studentId) => {
    const studentClassReportModal = (
      <StudentClassReportModal
        courseId={this.state.courseInfo.liveCourseId}
        studentId={studentId}
        onCancel={() => {
          this.setState({ studentClassReportModal: null });
        }}
      />
    );
    this.setState({
      studentClassReportModal,
    });
  };

  // 学员上课数据列表
  getStudentColumns() {
    const {
      courseState,
      consumeClassTime,
      consumeHourNum,
    } = this.state.courseInfo;
    const { type, currentEditData, hasOpenIntegral } = this.state;
    const columns = [
      {
        title: "用户姓名",
        dataIndex: "userName",
        width: 100,
      },
      {
        title: "手机号",
        dataIndex: "phone",
        render: (text, record) => {
          const { phone, bindingWeChat } = record;
          return (
            <div>
              {phone}
              {
                <Tooltip
                  title={`${bindingWeChat ? "已绑定微信" : "未绑定微信"}`}
                >
                  <span
                    className="icon iconfont"
                    style={
                      bindingWeChat
                        ? {
                            color: "#00D20D",
                            fontSize: "16px",
                            marginLeft: 6,
                          }
                        : {
                            fontSize: "16px",
                            color: "#BFBFBF",
                            marginLeft: 6,
                          }
                    }
                  >
                    &#xe68d;
                  </span>
                </Tooltip>
              }
            </div>
          );
        },
      },
      {
        title: "观看次数",
        dataIndex: "entryNum",
        align: "right",
        render: (text, record) => {
          if (text > 0) {
            if (
              record.visitorInfoVOList &&
              record.visitorInfoVOList.length > 0
            ) {
              const table = (
                <Table
                  columns={this.getVisiterColumns()}
                  dataSource={record.visitorInfoVOList}
                  scroll={{ y: 75 }}
                  size={"small"}
                  style={{ width: 450 }}
                  pagination={false}
                ></Table>
              );
              return (
                <Popover content={table} trigger="click">
                  <span className="handel-btn">{text}</span>
                </Popover>
              );
            } else {
              return <div className="live-table--empty">暂无上课数据</div>;
            }
          } else {
            return <span>{text}</span>;
          }
        },
      },
      {
        title: "累计在线时长",
        dataIndex: "watchDuration",
        width: 150,
        sorter: (a, b) => a.watchDuration - b.watchDuration,
        sortDirections: ["descend", "ascend"],
        render: (text, record) => {
          //如无离开时间，就置空
          return <span>{text ? dealTimeDuration(text) : "00:00:00"}</span>;
        },
      },
    ];

    return columns;
  }
  // 学员导出5.0
  handleExportV5 = () => {
    const { type, courseId } = this.state;
    const url =
      type === "large"
        ? "public/businessLive/exportLargeClassLiveAsync"
        : "public/businessLive/exportClassInteractionLiveSync";
    // window.axios
    //   .Apollo(url, {
    //     liveCourseId: courseId,
    //     exportLiveType: 'VISITOR',
    //   })
    //   .then((res) => {
    //     Bus.trigger('get_download_count');
    //     Modal.success({
    //       title: '导出任务提交成功',
    //       content: '请前往右上角的“任务中心”进行下载',
    //       okText: '我知道了',
    //     });
    //   });
  };

  handleCheckEnterTimes =()=>{

    return (<Popover
      placement="top"
      visible={visible}
      overlayClassName='popover-confirm'
      content={(
          <Table
            size="small"
            scroll={{ y: 600 }}
            columns={this.getStudentColumns()}
            dataSource={studentData}
            pagination={false}
            style={{ margin: "16px 0" }}
          />
      )}
    >
      <span
        style={{cursor: 'pointer'}}
        className="iconfont icon edit gray-icon"
        onClick={() => {
          setVisible(true)
        }}
      >&#xe6e7;</span>
    </Popover>)
  }


  render() {
    const {
      teacherData,
      studentData,
      current,
      size,
      total,
      loading,
    } = this.state;
    const {
      courseState,
      consumeClassTime,
      consumeHourNum,
    } = this.state.courseInfo;
    return (
      <Spin spinning={loading}>
        {/* 讲师上课数据 */}
        <div className="courseData-teacher">
          <p className="title">讲师上课数据</p>
          <div className="teacher-course-data">
            <div className="avatar-name-phone item-block">
              <img
                src={
                  teacherData.avatar ||
                  "https://image.xiaomaiketang.com/xm/rJeQaZxtc7.png"
                }
                alt=""
                className="avatar"
              />
              <div className="right">
                <div className="name">{teacherData.name || "王凯凯"}</div>
                <div className="phone">{teacherData.phone || "13888884388" }</div>
              </div>
            </div>

            <div className="times item-block">
              <div className={`times-num ${Number(teacherData.times) > 0 ? "can-click":""}`} onClick={()=>{this.handleCheckEnterTimes()}}>{teacherData.times || '47'}</div>
              <div className="text">进入直播间次数</div>
            </div>

            <div className="online-duration item-block">
              <div className="duration">{teacherData.duration || '20:30:45'}</div>
              <div className="text">累计在线时长</div>
            </div>
          </div>
        </div>

        {/* 用户上课数据 */}
        <div className="courseData-student">
          <p className="title">用户上课数据</p>
          <div className="filter-wrap">
            <div className="filter">
              <Button
                style={{ height: 32, marginLeft: 16 }}
                onClick={_.debounce(
                  () => {
                    if (!studentData.length) {
                      message.warning("暂无数据可导出");
                      return;
                    }
                      this.handleExportV5();
                  },
                  500,
                  true
                )}
              >
                导出
              </Button>
            </div>
          </div>

          <Table
            size="small"
            scroll={{ y: 600 }}
            columns={this.getStudentColumns()}
            dataSource={studentData}
            pagination={false}
            style={{ margin: "16px 0" }}
          />

          <PageControl
            size="small"
            current={current - 1}
            pageSize={size}
            total={total}
            toPage={(page) => {
              this.fetchStudentData(page + 1);
            }}
          />
        </div>
      </Spin>
    );
  }
}

export default withRouter(DataList);
