/*
 * @Author: 吴文洁
 * @Date: 2020-08-07 16:28:41
 * @LastEditors: wufan
 * @LastEditTime: 2020-12-11 15:29:27
 * @Description: 选择学员-筛选组件
 * @Copyright: 杭州杰竞科技有限公司 版权所有
 */

import React from 'react';
import { Row, Col } from 'antd';

import Bus from '@/core/bus';
import _ from 'underscore';

import { SearchBar } from '@/components';
import ClassSearchSelect from '@/modules/common/ClassSearchSelect';
import CourseSearchSelect from '@/modules/common/CourseSearchSelect';
import StaticSelect from '@/modules/common/StaticSelect';
import _ from 'underscore';
let resourceData = {};
_.map(window.RESOURCE, item => {
  resourceData[item.code] = item.name
});


class FilterContent extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      salesData: {},            // 跟进人列表
    }
  }

  componentDidMount() {
    //获取跟进人列表
    this.getPotentialAccountList()
  }

  //获取跟进人列表
  getPotentialAccountList() {
    const url = 'api-b/b/potential/account/list';
    window.axios.post(url).then((res) => {
      let salesData = {}
      _.map(res.data, item => {
        salesData[item.id] = item.name;
      });
      salesData[0] = '待分配';
      this.setState({ salesData });
    });
  }

  render() {
    const { salesData } = this.state;
    const { query, type, studentType } = this.props;
    const {
      status, nameOrPhone, classId, className,
      courseId, saleId, resourceType 
    } = query;


    // 是否是在读学员
    const isNormal = (status === 'NORMAL' || status === 1);
    // 是否是潜在学员
    const isPotential = (status === 'POTENTIAL' || status === 2);
    // 是否是历史学员
    const isHistory = (status === 'HISTORY' || status === 4);
    
    return (
      <div className="filter-content">
        <Row
          style={{
            display: 'flex',
            justifyContent: 'flexStart',
            alignItems: 'top',
            marginBottom: 12
          }}
        >
          <Col span={7}>
            <SearchBar
              type='select'
              placeholder='请输入学员姓名/手机号'
              options={{ 'name': '学员姓名', 'phone': '手机号' }}
              value={nameOrPhone}
              onSearch={(value) => {
                this.props.onChange('nameOrPhone', value);
              }}
            />
          </Col>
          {
            // 在读学员显示班级和课程筛选项
            ((isNormal && studentType === 'DEDUCTION' ) || isHistory)  &&
            <Col span={7} offset={1}>
              <CourseSearchSelect
                queryAll={true}
                placeholder='请选择课程'
                withGroup={true}
                onSelect={(course) => { this.props.onChange('courseId', course.id) }}
                defaultValue={courseId}
              />
            </Col>
          }

          {
            isNormal &&
            <Col span={7} offset={1}>
              <ClassSearchSelect
                placeholder='请选择班级'
                needName={true}
                className={className}
                courseId={courseId}
                defaultValue={classId}
                onSelect={(classesInfo) => { this.props.onChange('classId', classesInfo.classId);}}
              />
            </Col>
          }

          {
            isPotential &&
            [ 
              <Col span={7} offset={1} key="select-sale">
                <StaticSelect
                  id="liveCourse_selectSale"
                  dataSource={salesData}
                  placeholder='请选择跟进人'
                  width={150}
                  defaultValue={saleId}
                  onSelect={(value) => {
                    this.props.onChange('saleId', value.id);
                  }}
                />
              </Col>,
              <Col span={7} offset={1} key="select-resource-type">
                <StaticSelect
                  id="liveCourse_selectResourceType"
                  placeholder='请选择学员来源'
                  dataSource={resourceData}
                  defaultValue={resourceData[resourceType] ? resourceData[resourceType] : ''}
                  onSelect={(resourceTypeInfo) => { this.props.onChange('resourceType', resourceTypeInfo.id);}}
                />
              </Col>
            ]
          }

          <span
            className="icon iconfont"
            onClick={() => {
              Bus.trigger('resetSearchBar');
              this.props.onReset();
            }}
          >
            &#xe6a3;
          </span>
        </Row>
      </div>
    )
  }
}

export default FilterContent;
