import React, { useState, useEffect } from 'react';
import { Modal, Form, Button, Input, Radio, Row, Col } from 'antd';
import _ from 'underscore';
import './EmployeeAddOrEditModal.less';

const RadioGroup = Radio.Group;
declare let window: any;

interface AddEmployeeModalProps {
    isOpen: boolean,
    choosedItem: {
        name?: string,
        phone?: string,
        role?: string,
        avatar?: string
    },
    onClose:(e:any) => void
}

function AddEmployeeModal(props: AddEmployeeModalProps) {
    const [name, setName] = useState("");
    const [phone, setPhone] = useState("");
    const [role, setRole] = useState("");
    const [avatar, setavatar] = useState("");

    useEffect(() => {
        if (props.choosedItem.name) {
            setName(name);
            setPhone(phone);
            setRole(role);
            setavatar(avatar)
        }
    }, [props.choosedItem])

    const layout = {
        labelCol: { span: 5 },
        wrapperCol: { span: 12 },
    };

    const onFinish = (values: any) => {
        console.log('Success:', values);
    };

    const onFinishFailed = (errorInfo: any) => {
        console.log('Failed:', errorInfo);
    };


    function handleChangeRole(value: string) {
        setRole(value);
    }

    return (
        <Modal
            visible={props.isOpen}
            title={`${props.choosedItem.name ? '编辑员工' : "添加员工"}`}
            className="employee-add-modal"
            width={680}
            onCancel={props.onClose}
        >
            <Row>
                <Col span={16}>
                    <Form
                        {...layout}
                        name="basic"
                        initialValues={{ remember: true }}
                        onFinish={onFinish}
                        onFinishFailed={onFinishFailed}
                    >
                        <Form.Item
                            label="员工姓名"
                            name="name"
                            rules={[{ required: true, message: '' }]}
                        >
                            <Input
                                style={{ width: 200 }}
                                value={name}
                                placeholder="请输入员工名称"
                                maxLength={15}
                            />
                        </Form.Item>

                        <Form.Item
                            label="手机号码"
                            name="phone"
                            rules={[{ required: true, message: '' }]}
                        >
                            <Input
                                style={{ width: 200 }}
                                value={phone}
                                placeholder="请输入手机号"
                                maxLength={11}
                            />
                        </Form.Item>

                        <Form.Item
                            label="员工身份"
                            name="role"
                            rules={[{ required: false }]}
                        >
                            <RadioGroup
                                value={!!(role === "NORMAL")}
                                onChange={(e) => {
                                    handleChangeRole(e.target.value);
                                }}
                            >
                                <Radio value={true}>
                                    <span style={{ color: '#333' }}>普通讲师</span>
                                    <p className="radio-tip">仅可查看/使用与自己相关的文件和课表，并进行上课</p>
                                </Radio>
                                <Radio value={false}>
                                    <span style={{ color: '#333' }}>管理员</span>
                                    <p className="radio-tip">可执行店铺中所有的操作</p>
                                </Radio>
                            </RadioGroup>
                        </Form.Item>
                    </Form>
                </Col>


                <Col span={8}>
                    <div className="avatar-box">
                        <div className="avatar-text">头像</div>
                        <div className="avatart-img"></div>
                        <div className="upload-avatar">上传头像</div>
                    </div>
                </Col>
            </Row>
        </Modal>
    )
}

export default AddEmployeeModal;