/*
 * @Author: 吴文洁
 * @Date: 2020-08-20 09:21:40
 * @LastEditors: wufan
 * @LastEditTime: 2021-08-15 18:31:08
 * @Description: 
 * @Copyright: 杭州杰竞科技有限公司 版权所有
 */
import { MapInterface } from '@/domains/basic-domain/interface'
const ENV: string = process.env.DEPLOY_ENV || 'dev';

const appIdMap: MapInterface = {
  dev: 'wx3ea60e78ddfa277e',
  dev1: 'wx3ea60e78ddfa277e',
  rc: 'wx5c5a1fb71ecab7bc',
  gray: "wx3dda02036493ada6", // 小麦校讯通
  prod: 'wx3dda02036493ada6'
}

const shareUrlMap: MapInterface = {
  'dev': 'https://dev.xiaomai5.com/share/show?appid=',
  'dev1': 'https://dev.xiaomai5.com/share/show?appid=',
  'rc': 'https://rc.xiaomai5.com/share/show?appid=',
  'prod': 'https://prod.xiaomai5.com/share/show?appid=',
  'gray': 'https://prod.xiaomai5.com/share/show?appid='
}

const LIVE_SHARE_MAP: MapInterface = {
  dev: 'https://dev.xiaomai5.com/store-live/index.html#/',
  dev1: 'https://dev.xiaomai5.com/store-live/index.html#/',
  rc: 'https://rc.xiaomai5.com/store-live/index.html#/',
  gray: 'https://res.xiaomai0.com/store-live/gray/index.html#/',
  prod: 'https://res.xiaomai0.com/store-live/index.html#/',
}




export const appId: string = appIdMap[ENV];
export const shareUrl: string = shareUrlMap[ENV];
export const LIVE_SHARE: string = LIVE_SHARE_MAP[ENV];
