import React, { useState, useEffect } from "react";
import "./TestLinkTaskData.less";
import LeftStageList from "./LeftStageList";
import TestDetailPage from "@/modules/teach-tool/examination-manager/TestDetailPage";
import { Route, withRouter } from "react-router-dom";
import Service from "@/common/js/service";
import LottieIcon from "@/components/LottieIcon";
import User from '@/common/js/user';

function TestLinkTaskData(props) {
  const [stageExamList, setStageExamList] = useState([]);
  const [activeExam, setActiveExam] = useState({});
  const [activeStage, setActiveStage] = useState({});
  const [isShow, setIsShow] = useState(true);
  const {taskId, detail: {storeCustomerId}} = props;

  useEffect(() => {
    getTrainingTaskDetail();
  }, []);

  function getTrainingTaskDetail() {
    
    Service.Hades("public/hades/getTaskCustomerDetail", {
      taskId: taskId,
      storeId:  User.getStoreId(),
      storeCustomerId: storeCustomerId,
    }).then((res) => {
      const data = { ...res.result };
      const { stageExamCustomerVOList = [] } = data;
      if (!!stageExamCustomerVOList.length) {
        setStageExamList(stageExamCustomerVOList);
        setActiveStage(stageExamCustomerVOList[0]);
        setActiveExam(stageExamCustomerVOList[0].contentVOList[0]);
        const { contentId, paperId } = stageExamCustomerVOList[0].contentVOList[0];
        const { match } = props;
        const path = `${match.url}/test-detail/${contentId}?paperId=${paperId}1&userId=${storeCustomerId}&fromTrainingTask=true`;
        window.RCHistory.replace(path);
      }
    });
  }

  function changeActiveExam(_activeExam, _activeStage) {
    console.log("_activeExam", _activeExam);
    setActiveExam(_activeExam);
    setActiveStage(_activeStage);
    const { contentId, paperId } = _activeExam;
    const { match } = props;
    const path = `${
      match.url
    }/test-detail/${contentId}?paperId=${paperId}&userId=${111}`;
    window.RCHistory.replace(path);
  }

  function toggleShowBar(diretion) {
    if (diretion === "left") {
      setIsShow(false);
    } else {
      setIsShow(true);
    }
  }

  return (
    <div>
      {stageExamList.length ? (
        <div className={`test-link-task-data ${!isShow ? 'hidden':''}`}>
          <div className={`left-stage-list-box ${!isShow ? 'hidden':''}`}>
            {isShow ? (
              <div
                className="left-bar"
                onClick={() => {
                  toggleShowBar("left");
                }}
              ></div>
            ) : (
              <div
                className="right-bar"
                onClick={() => {
                  toggleShowBar("right");
                }}
              ></div>
            )}
            <LeftStageList
              stageExamList={stageExamList}
              activeExam={activeExam}
              changeActiveExam={changeActiveExam}
              activeStage={activeStage}
            />
          </div>
          <div className={`right-exam-data-box ${!isShow ? 'hidden':''}`}>
            {/* 未考过的考试显示暂无考试数据，否则请求接口会报错 */}
            {
              activeExam.learnFinishPercentage === 0 ? 
              <LottieIcon
              title={<span className="desc">暂无考试数据</span>}
              type="college"
              size={150}
            /> : 
            <Route
            path={`${props.match.url}/test-detail/:testId`}
            component={TestDetailPage}
          />
            }
          </div>
        </div>
      ) : (
        <LottieIcon
          title={<span className="desc">暂无考试数据</span>}
          type="college"
          size={150}
        />
      )}
    </div>
  );
}

export default withRouter(TestLinkTaskData);
