import React, { useState, useRef, useEffect, useContext } from 'react'
import { Route, withRouter } from 'react-router-dom';
import Breadcrumbs from "@/components/Breadcrumbs";
import moment from 'moment'
import { LIVE_SHARE } from "@/domains/course-domain/constants";
import { Form, Alert, Input, Button, InputNumber, DatePicker, Select, Radio, message, Modal } from 'antd';
import Service from "@/common/js/service";
import User from "@/common/js/user";
import qrcode from "@/libs/qrcode/qrcode.js";

declare var wx: any;
const { Option } = Select;

const courseType = {
    0: '通用直播',
    1: '小班课',
    2: '大班课',
    3: '企业培训',
    4: '活动直播'
}


function CerateQWCourse(props: any) {
    const [courseName, setCourseName] = useState('');
    const [liveDuration, setLiveDuration] = useState(60);
    const [liveStart, setLiveStart] = useState(0);
    const [type, setType] = useState('0');
    const [livingId, setLivingId] = useState(0);

    function handleSave() {
        const param = {

            courseName,
            description: '直播的简介,最多支持300个字节直播的简介,最多支持300个字节直播的简介,最多支持300个字节直播的简介,最多支持300个字节直播的简介,最多支持300个字节直播的简介,最多支持300个字节',
            liveDuration: liveDuration * 60 * 100,
            liveStart,
            remindTime: 1000 * 60 * 10,
            storeId: User.getStoreId(),
            storeUserId: User.getStoreUserId(),
            type: parseInt(type)
        }
        Service.Hades('anon/hades/wxWorkCreateLiveDemo', param).then((res) => {
            console.log(22)
            handleConvertShortUrl(res.result)
            setLivingId(res.result)
            wx.invoke('startLiving', {
                "livingId": res.result,
            }, function (res: any) {
                console.log(122, res)
                if (res.err_msg == "startLiving:ok") {
                    // livingId = res.livingId;
                }
            });
        })
    }


    function handleConvertShortUrl(id: any) {
        const longUrl = `${LIVE_SHARE}qw/live/${id}?id=${User.getStoreId()}`
        console.log(longUrl)
        // 发请求
        Service.Sales('public/businessShow/convertShortUrls', {
            urls: [longUrl]
        }).then((res) => {
            const { result = [] } = res;
            const qrcodeWrapDom: any = document.querySelector('.qrcode');
            qrcodeWrapDom.innerHTML = ''
            const qrcodeNode = new qrcode({
                text: result[0].shortUrl,
                size: 100,
            });
            (qrcodeWrapDom as any).appendChild(qrcodeNode);
        })
    }


    function downloadLivingReplay(){
        wx.invoke('downloadLivingReplay', {
            livingId
        }, function(res:any) {
            console.log(res,'tyuuioythbn')
            if (res.err_msg != "downloadLivingReplay:ok") {
                // 错误处理
            }
        });
    }

    return <div className="page createQWCourse ">
        <Breadcrumbs navList={props.type === 'edit' ? "编辑考试" : "新建直播课"} goBack={props.history.goBack} />


        <div className="box">

            <div className="form">
                <div className="title">直播信息</div>
                <Form
                    labelCol={{ span: 3 }}
                    wrapperCol={{ span: 14 }}
                    layout="horizontal"
                >
                    <Form.Item label="课程名称"

                        required>
                        <Input value={courseName} onChange={(e) => { setCourseName(e.target.value) }} style={{ width: 200 }} ></Input>

                    </Form.Item>

                    <Form.Item label="持续时长"

                        required>
                        <InputNumber value={liveDuration} max={1440} min={1} onChange={(value: any) => { setLiveDuration(parseInt(value) as any) }} style={{ width: 100 }} />

                    </Form.Item>

                    <Form.Item label="开始时间"

                        required>
                        <DatePicker
                            format="YYYY/MM/DD HH:mm"
                            value={liveStart ? moment(Number(liveStart)) : null}
                            style={{ width: 200 }}
                            placeholder="开始时间"
                            showTime
                            onChange={(date: any) => { setLiveStart(date ? date.valueOf() : 0) }}
                        />

                    </Form.Item>
                    <Form.Item label="直播的类型"

                        required>
                        <Select value={type} placeholder="请选直播的类型" style={{ width: 200 }} onChange={(val) => {
                            setType(val)
                        }} >
                            {
                                Object.keys(courseType).map((key: any) => {
                                    return <Option value={key}>{(courseType as any)[key]}</Option>
                                })
                            }


                        </Select>

                    </Form.Item>



                </Form>
            </div>

        </div>
        <div style={{marginTop:100}} className="qrBox">
            <div style={{width:100,margin:'0 auto'}}  className="qrcode"></div>
        </div>
        <div className="footer">
        <Button onClick={downloadLivingReplay}>下载直播回放</Button>
            <Button onClick={props.history.goBack}>取消</Button>
            <Button type="primary" onClick={handleSave}>保存</Button>
        </div>
    </div>
}

export default withRouter(CerateQWCourse);