import React, { useContext, useEffect, useRef, useState } from 'react';
import {
  withRouter,
} from 'react-router-dom';
import { Menu, Popover, Tooltip } from 'antd';
import { RightOutlined } from '@ant-design/icons'
import { menuList } from '../../routes//config/menuList'
import { XMContext } from '../../store/context';
import BaseService from "@/domains/basic-domain/baseService";
import StoreService from '@/domains/store-domain/storeService';
import classNames from 'classnames';
import User from "@/common/js/user"
import _ from 'underscore';
import "./Menu.less";
import { display } from 'html2canvas/dist/types/css/property-descriptors/display';
import moment from 'moment';

const { SubMenu } = Menu;

interface VersionInfo {
  dayTime: number
  stateEnum: string
  surplusDayTime: number
  surplusUserNum: number
  userNum: number
  validEndTime: string
  validStartTime: string
}

function VersionPanel(props:any) {

  const [versionName,setVersionName] = useState("标准版")
  const [showVersionPopover, setShowVersionPopover] = useState(false)
  const [showRenewPopover, setShowRenewPopover] = useState(false)
  const [isExpiration, setIsExpiration] = useState(false)
  const [versionInfo, setVersionInfo] = useState<any>({})

  useEffect(()=> {
    BaseService.getLesseeVersionMsg()
    .then(res=> {
      let version = res.result
      User.setVersion(version)

      let versioninfo = {
        userNum: version.userNum,
        surplusUserNum: version.surplusUserNum,
        surplusDayTime: version.surplusDayTime,
        validEndTime: moment(version.validEndTime).format("YYYY-MM-DD"),
        validStartTime: moment(version.validStartTime).format("YYYY-MM-DD"),
      }
      setVersionInfo(versioninfo)

      if (version.surplusDayTime === 0) {
        setIsExpiration(true)
      }
    })
  },[])

  function onVersionEnter() {
    setShowVersionPopover(true)
  }
  function onVersionLeave() {
    setShowVersionPopover(false)
    setShowRenewPopover(false)
  }
  function onRenewClick() {
    setShowRenewPopover(true)
    setShowVersionPopover(false)
  }

  const versionPopoverClass = classNames({
    'popover':true,
    'popover-show':showVersionPopover
  })
  const renewPopoverClass = classNames({
    'renew-popover': true,
    'renew-popover-show': showRenewPopover
  })

  return (
    <div className="version-info" onMouseEnter={onVersionEnter} onMouseLeave={onVersionLeave}>
    <div className="row-1">
      <div className="version-name">{versionName}</div>
      <div className="renew" onClick={onRenewClick}>去续费<span className="icon iconfont" style={{fontSize:"10px"}}>&#59291;</span>
      <div className={renewPopoverClass}>
        <div className="qrcode">
          <img src="https://cdn.xiaomai5.com/qixueyuankehu.png" alt=""></img>
          <div className="des">微信/企业微信扫码续费</div>
        </div>
        <div className="phone"><svg style={{position:"relative",top:"2px",marginRight:"4px"}} viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path d="M512.651 3.78c-281.433 0-509.21 228.324-509.21 509.209 0 281.43 228.325 509.203 509.21 509.203 281.427 0 509.202-228.317 509.202-509.203 0.55-280.885-227.775-509.21-509.202-509.21z m198.205 743.553c-36.14 36.136-169.737 1.641-302.24-130.312-131.953-131.959-165.902-266.104-129.768-301.695 31.211-31.21 68.99-85.417 125.939-14.782 56.943 70.629 29.016 90.34-3.291 122.647-22.449 22.448 24.642 79.392 73.37 128.125 49.283 48.73 105.678 95.818 128.126 73.368 32.306-32.305 52.017-60.23 122.646-3.288 71.182 56.949 16.426 95.276-14.782 125.937z" p-id="4409" fill="#999999"></path></svg>
        咨询电话：19157875632</div>
      </div>
      </div>
    </div>
    <div className="expiration-time">有效期至{versionInfo.validEndTime}{isExpiration ? "(已过期)" : ""}</div>
    <div className={versionPopoverClass}>
      <div className="title">版本信息</div>
      {isExpiration ? <div className="expiration-tag">已过期</div> : ""}
      
      <div className="content">
        <div className="widget" style={{marginRight:"40px",marginBottom:"16px"}}>
          <div className="lable">剩余天数</div>
          <div className="lable-text">{versionInfo.surplusDayTime}</div>
        </div>
        <div className="widget" style={{marginBottom:"16px"}}>
          <div className="lable">有效起止日期</div>
          <div className="lable-text">{versionInfo.validStartTime}~{versionInfo.validEndTime}</div>
        </div>
        <div className="widget" style={{marginRight:"40px",marginBottom:"8px"}}>
          <div className="lable">剩余人数</div>
          <div className="lable-text">{versionInfo.surplusUserNum}</div>
        </div>
        <div className="widget" style={{marginBottom:"8px"}}>
          <div className="lable" style={{display:"inline-block"}}>人数限制</div>
            <Tooltip overlayStyle={{maxWidth:"587px",width:"587px"}} placement="topLeft" arrowPointAtCenter title={()=>{ return (<div><div>1、若员工/学员存在多个学院，企业人数只统计为1人；</div><div>2、若一个学员既用「企业微信」登录学习又用「微信」登录学习，企业人数将统计为2人。</div></div>)}}>
            <div  style={{display:"inline-block",position:"relative",top:"2px",marginLeft:"4px"}}><span><svg viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1026" width="14" height="14"><path d="M512 68.266667c245.111467 0 443.733333 198.656 443.733333 443.733333s-198.621867 443.733333-443.733333 443.733333C266.922667 955.733333 68.266667 757.077333 68.266667 512S266.922667 68.266667 512 68.266667z m29.320533 596.548266c0.477867-27.989333 2.4576-48.196267 5.802667-60.654933 3.413333-12.458667 8.567467-23.4496 15.633067-33.0752 6.997333-9.557333 21.9136-24.507733 44.714666-44.714667 33.928533-30.037333 56.797867-55.637333 68.437334-76.5952a139.1616 139.1616 0 0 0 17.5104-68.846933c0-43.008-16.5888-79.701333-49.800534-110.011733-33.1776-30.378667-77.6192-45.533867-133.358933-45.533867-52.6336 0-94.958933 14.1312-126.976 42.3936-31.9488 28.2624-51.268267 68.949333-57.685333 122.094933l71.8848 8.533334c6.212267-39.6288 19.3536-68.778667 39.3216-87.483734 19.933867-18.6368 44.817067-27.989333 74.6496-27.989333 30.788267 0 56.900267 10.308267 78.165333 30.9248 21.265067 20.5824 31.880533 44.544 31.880533 71.748267 0 15.018667-3.618133 28.910933-10.922666 41.608533-7.168 12.731733-22.971733 29.764267-47.240534 51.131733-24.200533 21.367467-41.028267 37.649067-50.346666 48.810667-12.6976 15.291733-21.9136 30.481067-27.613867 45.533867-7.748267 19.933867-11.639467 43.690667-11.639467 71.133866 0 4.676267 0.1024 11.707733 0.341334 21.026134h67.242666z m8.192 140.3904v-79.735466h-79.701333v79.735466h79.701333z" fill="#bfbfbf" p-id="1027"></path></svg></span></div>
            </Tooltip> 
          <div className="lable-text">{versionInfo.userNum}</div>
        </div>
      </div>
    </div>
  </div>
  )
}


function Aside(props: any) {
  const {menuType,handleMenuType}= props
  const ctx: any = useContext(XMContext);
  const [selectKey, setSelectKey] = useState();
  const [openKeys, setOpenKeys] = useState(['']);
  const [topLogoUrl, setTopLogoUrl] = useState("")
  const [collapsed, setCollapsed] = useState(false)
  const rootSubmenuKeys = _.pluck(menuList, 'groupCode');
  useEffect(() => {
    const link = props.location.pathname;
    menuList.map((item: any, index: any) => {
      if (link.indexOf(item.link) !== -1) {
        setSelectKey(item.groupCode);
        setOpenKeys([])
      } else if (item.children) {
        item.children.map((_item: any, _index: any) => {
          if (link.indexOf(_item.link) !== -1) {
            setSelectKey(_item.groupCode + index + _index);
          }
        })
      }
      return item;
    })
  }, [props.location.pathname])
  useEffect(()=> {
    getTopLeftLogo()
  },[])
  function getTopLeftLogo() {
    if (User.getToken()) {
      StoreService.getStoreDetail({storeId:User.getStoreId()})
      .then(res=> {
        if (_.isEmpty(res.result.logo)) {
          setTopLogoUrl("https://image.xiaomaiketang.com/xm/fe4NCjr7XF.png")
        } else {
          setTopLogoUrl(res.result.logo)
        }
        
      })
    }
  }
  function toggleMenu(item: any) {
    window.RCHistory.push(item.link)
    // if (!menuType) {
    //   setOpenKeys([])
    // }
  }
  function onOpenChange(key: any) {
    if (openKeys.includes(key)) {
      setOpenKeys([]);
    } else {
      setOpenKeys([key]);
    }
  }
  function onOpenChangeForHover(key: any) {
    if (menuType) {
      return
    }
    if (openKeys.includes(key)) {
      setOpenKeys([]);
    } else {
      setOpenKeys([key]);
    }
  }
  function handleMenu() {
    handleMenuType();
    setCollapsed(!collapsed)
  }

  return (
    <div 
        id="left-container"
        className={
          menuType
            ? "left-container"
            : "left-container left-container-vertical"
        }
      >
        <div className="top-ctrl">
        <div className="topLogo">
          { menuType && <img src={topLogoUrl} alt="" className="img1"></img> }
        </div>
        <div className="menu-type-icon"  onClick={handleMenu}>
          {menuType ? (
            <span
              className="icon iconfont"
            >
              &#xe83d;
            </span>
          ) : (
            <span
              className="icon iconfont"
            >
              &#xe615;
            </span>
          )}
        </div>
        </div>
        
        <div className="left">
          <div className="nav">

        <Menu
          style={{ minHeight: "100%", background: '#0E1935' }}
          inlineCollapsed={collapsed}
          mode={menuType ? "inline" : "vertical"}
        >
          {
            menuList.map((item: any, index: any) => {
              if (ctx.xmState.storeUserPermissionList.indexOf(item.groupCode) === -1) {
                return null;
              }
              if (item.children) {
                return <SubMenu 
                        key={item.groupCode} 
                        style={{ marginTop: 0 }} 
                        title={<div><img src={item.img} className="icon-img"></img><span>{item.groupName}</span></div> } 
                        onTitleClick={() => onOpenChange(item.groupCode)}>
                  {
                    item.children.map((_item: any, _index: any) => {
                      if (ctx.xmState.storeUserPermissionList.indexOf(_item.groupCode) === -1) {
                        return null;
                      }
                      return <Menu.Item onClick={() => { toggleMenu(_item) }} style={{ marginTop: 0 }} key={_item.groupCode + index + _index}>
                        <span className="name">{_item.groupName}</span>
                      </Menu.Item>

                    })
                  }
                </SubMenu>
              } else {
                return <Menu.Item 
                        onClick={() => { toggleMenu(item) }} 
                        key={item.groupCode} 
                        icon={selectKey === item.groupCode ? <img src={item.selectImg} className="icon-img"></img>:<img src={item.img} className="icon-img"></img>}
                        >
                    {menuType ? item.groupName : ""}
                </Menu.Item>
              }
            })
          }
        </Menu>
      </div>
      
      </div>
      <VersionPanel />
      
    </div>
  );
}

export default withRouter(Aside);