/*
 * @Author: 吴文洁
 * @Date: 2020-04-27 20:35:34
 * @LastEditors: Please set LastEditors
 * @LastEditTime: 2021-07-08 19:22:18
 * @Description:
 */

import React, { useEffect, useState } from "react";
import ReactDOM from 'react-dom';
import { HashRouter } from 'react-router-dom';
import { ConfigProvider } from 'antd';
import { createHashHistory } from 'history';
import zh_CN from 'antd/es/locale/zh_CN';
import _ from 'underscore';
import { RootRouter } from './routes/index';
import 'antd/dist/antd.less';
import 'video-react/dist/video-react.css';
import '@/common/less/index.less';
import '@/core/downloads';
import '@/core/function';
import '@/core/xmTD';
import User from '@/common/js/user';
import Service from "@/common/js/service";
import BaseService from '@/domains/basic-domain/baseService';
import routeHook from '@/core/routeHook'

declare var getParameterByName: any;
declare var window: any;
window.currentStoreUserInfo = {}
const history = createHashHistory();

window.RCHistory = _.extend({}, history, {
  push: (obj: any) => {
    console.log(routeHook.getCallbackNum(), 'routeHook.getCallbackNum()')
    if (routeHook.getCallbackNum()) {
      routeHook.break();
      routeHook.addJump(() => {
        history.push(obj)
      })
    } else {
      history.push(obj)
    }

  },
  pushState: (obj: any) => {
    history.push(obj)
  },
  pushStateWithStatus: (obj: any) => {
    history.push(obj)
  },
  goBack: () => {
    console.log(routeHook.getCallbackNum(), 'routeHook.getCallbackNum()')

    history.goBack()
  },
  location: history.location,
  replace: (obj: any) => {
    history.replace(obj)
  }
});

window.onhashchange = () => {
  routeHook.cancel()
}

function mount() {
  ReactDOM.render(
    <RootRouter />,
    document.getElementById('root'));
}

function isWeiXin() {
  const ua = navigator.userAgent.toLowerCase();
  return ua.indexOf('micromessenger') > 0;
}

console.log(isWeiXin(), 'isWeiXin()')

if (getParameterByName('code') && isWeiXin()) {
  Service.Hades('anon/hades/wXWorkLogin', {
    appTermEnum: 'XIAOMAI_CLOUD_CLASS_PC_WEB_ADMIN',
    code: getParameterByName('code')
  }).then((res) => {
    User.setUserId(res.result.loginInfo.userId);
    User.setToken(res.result.loginInfo.xmToken);
    User.setEnterpriseId(res.result.enterpriseId);
    window.currentStoreUserInfo = {}
    window.currentStoreUserInfo.userId = res.result.loginInfo.userId;
    window.currentStoreUserInfo.token = res.result.loginInfo.xmToken;
    window.currentStoreUserInfo.enterpriseId = res.result.enterpriseId;
    mount()
  })
} else if (getParameterByName('from') === 'customer' && getParameterByName('enterpriseId') && getParameterByName('userId')) {
  User.setCustomerStoreId(getParameterByName('storeId'));
  getWXWorkLoginNoCheck(getParameterByName('enterpriseId'), getParameterByName('userId'));  //从C端跳转过来的学院自动执行免登录
} else {
  mount()
}
function getWXWorkLoginNoCheck(enterpriseId: string, userId: string) {
  const params = {
    appTermEnum: 'XIAOMAI_CLOUD_CLASS_PC_WEB_ADMIN',
    enterpriseId,
    userId,
  };
  BaseService.getWXWorkLoginNoCheck(params).then((res: any) => {
    User.setUserId(res.result.loginInfo.userId)
    User.setToken(res.result.loginInfo.xmToken)
    User.setEnterpriseId(res.result.enterpriseId)
    window.currentStoreUserInfo = {}
    window.currentStoreUserInfo.userId = res.result.loginInfo.userId;
    window.currentStoreUserInfo.token = res.result.loginInfo.xmToken;
    window.currentStoreUserInfo.enterpriseId = res.result.enterpriseId;
    User.setIdentifier(res.result.identifier)
    mount();
  });
}
