import React, { useState, useEffect } from 'react';
import { Modal, Form, Button, Input, Radio, Row, Col ,InputNumber } from 'antd';
import _ from 'underscore';
import './IdentificationModal.less';

interface IdentificationModalProps {
    onClose:() => void,
    phone:String,
    onConfirm:() => void
}

function IdentificationModal(props: IdentificationModalProps) {
    const {onClose, phone ,onConfirm} = props;
    const [phoneVerify, setPhoneverify] = useState(''); // 验证身份的验证码
    const [codeText, setCodeText] = useState('发送验证码');
    const [waitStatus, setWaitStatus] = useState(false); // 验证码是否在倒计时
    const [phoneVerifyError,setPhoneVerifyError] =  useState(false);

    const [errorMessageText,setErrorMessageText] =  useState('');

    useEffect(() => {
     
    })
    function handleConfirm():any {
        if(!phoneVerify){
            setPhoneVerifyError(true);
            setErrorMessageText('请输入验证码');
           return;
        }
        // 请求身份确定的接口
        onConfirm();
    }
    
    function handleSendCode():any {
       if (waitStatus) return;
        let timer:any;
        timeSub(60,0);
        function timeSub(waitTime:number, unit:number):any{
            clearTimeout(timer);
            timer = setTimeout(function () {
                if (waitTime == 0) {
                setCodeText('发送验证码')
                setWaitStatus(false)
                clearTimeout(timer);
                } else {
                    setCodeText(`${waitTime}秒后重发`)
                    setWaitStatus(true)
                    timeSub(--waitTime, 1000);
                }
            }, unit || 0);
        }
    }
    return (
        <Modal
            visible={true}
            title="身份验证"
            width={448}
            onCancel={onClose}
            className="identification-modal"
            footer={[
                <Button
                  id='cancel_allot_btn'
                  key="back" onClick={onClose}>取消</Button>,
                <Button
                  id='confirm_allot_btn'
                  key="submit"
                  type="primary"
                  onClick={() => {
                    handleConfirm()
                  }}>
                  确认
                </Button>
              ]}
        >
     
        <div className="desc">为了你的账户安全，请验证身份。验证成功后进行下一步操作</div>
        <div className="phone">{phone}</div>
        <div className="verify-content">
            <Input
                type="number"
                name="phoneverify"
                placeholder="验证码"
                className={ phoneVerifyError ? 'error-input' : ''}
                maxLength={4}
                value={phoneVerify}
                onChange={(e) => { 
                    setPhoneverify(e.target.value);
                    setPhoneVerifyError(false);
                    setErrorMessageText('')
                }}
                style={{ width:200,height:32}}
            />
            <span
                className="send-code"  
                onClick={() => {
                    handleSendCode();
                }}>
                {codeText}
            </span>
        </div>
        <div className="error-message">{errorMessageText}</div>
      
        </Modal>
    )
}

export default IdentificationModal;