import React, { useContext, useEffect, useState } from 'react';
import {
  withRouter,
} from 'react-router-dom';
import { Menu } from 'antd';
import { menuList } from '../../routes//config/menuList'
import { XMContext } from '../../store/context';
import Bus from '@/core/bus'
import "./Menu.less";
const { SubMenu } = Menu;


function Aside(props: any) {
  const ctx: any = useContext(XMContext);
  const [selectKey, setSelectKey] = useState();
  const [openKeys, setOpenKeys] = useState(['']);
  const [menuType,setMenuType] = useState(1);
 
  useEffect(() => {
    const link = props.location.pathname;
    menuList.map((item: any, index: any) => {
      if (link.indexOf(item.link) !== -1) {
        setSelectKey(item.groupCode);
        setOpenKeys([])
      } else if (item.children) {
        item.children.map((_item: any, _index: any) => {
          if (link.indexOf(_item.link) !== -1) {
            setSelectKey(_item.groupCode + index + _index);
          }
        })
      }
      return item;
    })
  }, [props.location.pathname])
  function taggleMenu(item: any) {
    window.RCHistory.push(item.link)
  }
  function onOpenChange(openKeys: string[]) {
    setOpenKeys(openKeys)
  }
  return (
    <div 
      id="left-container"
      className={
      menuType
        ? "left-container"
        : "left-container left-container-vertical"
      }
      >
        <div className="left">
          <div className="nav">

        <Menu
          style={{ minHeight: "100%", background: '#0E1935' }}
          defaultSelectedKeys={selectKey}
          selectedKeys={selectKey}
          openKeys={openKeys}
          onOpenChange={onOpenChange}
          mode="inline"
          theme="dark"
          inlineCollapsed={false}

        >
          {
            menuList.map((item: any, index: any) => {
              if (ctx.xmState.storeUserPermissionList.indexOf(item.groupCode) === -1) {
                return null;
              }
              if (item.children) {
                return <SubMenu key={item.groupCode} style={{ marginTop: 0 }} title={<div> 
                  <span style={{ marginRight: 6 }} className="iconfont icon" dangerouslySetInnerHTML={{ __html:item.icon}}></span>
                  <span>{item.groupName}</span></div>}>
                  {
                    item.children.map((item: any, _index: any) => {
                      return <Menu.Item onClick={() => { taggleMenu(item) }} style={{ marginTop: 0 }} key={item.groupCode + index + _index}>
                        <span>{item.groupName}</span>
                      </Menu.Item>
                    })
                  }
                </SubMenu>
              } else {
                return <Menu.Item onClick={() => { taggleMenu(item) }} key={item.groupCode}>
                  <span style={{ marginRight: 6 }} className="iconfont icon" dangerouslySetInnerHTML={{ __html:item.icon}}></span>
                  <span>{item.groupName}</span>
                </Menu.Item>
              }
            })
          }

        </Menu>
      </div>
      </div>
    </div>
  );
}

export default withRouter(Aside);