/*
 * @Description:
 * @Author: zangsuyun
 * @Date: 2021-03-12 11:16:38
 * @LastEditors: zangsuyun
 * @LastEditTime: 2021-03-25 14:21:44
 * @Copyright: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React from "react";
import { Row, Input, Select, Tooltip } from "antd";

import "./KnowledgeBase.less";
import ENUM from "../ENUM.js";
const { Search } = Input;
const { Option } = Select;

const DEFAULT_QUERY = {
  name: null, // 课程名称
  // operatorId: null, // 创建人
  // beginTime: null, // 开始日期
  // endTime: null, // 结束日期
  type: null,
};

class KnowledgeBaseFilter extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      query: { ...DEFAULT_QUERY }, // 使用扩展运算符,避免浅拷贝
    };
  }
  
  // 改变搜索条件
  handleChangeQuery = (field, value) => {
    this.setState(
      {
        query: {
          ...this.state.query,
          [field]: value,
          current: 1,
        },
      },
      () => {
        this.props.onChange(this.state.query);
      }
    );
  };

  // 重置搜索条件
  handleReset = () => {
    this.setState(
      {
        query: DEFAULT_QUERY,
      },
      () => {
        this.props.onChange(this.state.query);
      }
    );
  };

  render() {
    const {
      query: {
        courseName,
        courseType,
      },
    } = this.state;

    return (
      <div className="knowledge-base-filter">
        <Row type="flex" justify="space-between" align="top">
          <div className="search-condition">
            <div className="search-condition__item">
              <span className="search-name">课程名称：</span>
              <Search
                value={courseName}
                placeholder="搜索课程名称"
                // onChange={(e) => {
                //   this.handleChangeQuery("name", e.target.value);
                // }}
                onSearch={(value) => {
                  this.handleChangeQuery("name", value);
                }}
                style={{ width: "calc(100% - 84px)" }}
                enterButton={<span className="icon iconfont">&#xe832;</span>}
              />
            </div>

            <div className="search-condition__item">
              <span className="shelf-status">课程类型：</span>
              <Select
                style={{ width: "calc(100% - 84px)" }}
                placeholder="请选择课程类型"
                allowClear={true}
                value={courseType}
                onChange={(value) => {
                  this.handleChangeQuery("type", value);
                }}
                suffixIcon={
                  <span
                    className="icon iconfont"
                    style={{ fontSize: "12px", color: "#BFBFBF" }}
                  >
                    &#xe835;
                  </span>
                }
              >
                {Reflect.ownKeys(ENUM.CourseTypeEnum).map((item) => {
                  return (
                    <Option value={item}>{ENUM.CourseTypeEnum[item]}</Option>
                  );
                })}
              </Select>
            </div>
          </div>
          <div className="reset-fold-area">
            <Tooltip title="清空筛选">
              <span
                className="resetBtn iconfont icon"
                onClick={this.handleReset}
              >
                &#xe61b;{" "}
              </span>
            </Tooltip>
          </div>
        </Row>
      </div>
    );
  }
}

export default KnowledgeBaseFilter;
