import PropTypes from 'prop-types';
import React from 'react';
import { DatePicker } from 'antd';
import moment from 'moment';
const { RangePicker } = DatePicker;

class DateRangePicker extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    }
  }

  render() {
    const showTime = { showTime: true }
    return (
      <RangePicker
        {...this.props}
        format={this.props.format || 'YYYY-MM-DD'}
        allowClear={this.props.allowClear}
        ranges={this.props.ranges || { '本月': [moment().startOf('month'), moment().endOf('month')], '本周': [moment().startOf('week'), moment().endOf('week')], '上月': [moment().subtract(1, 'M').startOf('month'), moment().subtract(1, 'M').endOf('month')], '上周': [moment().subtract(1, 'w').startOf('week'), moment().subtract(1, 'w').endOf('week')] }}
        onChange={(date) => {
          if (!_.isEmpty(date)) {
            date[0] = date[0].startOf('day')
            date[1] = date[1].endOf('day')
          }
          this.props.onChange(date)
        }}
        {...showTime}
      />
    )
  }

}

DateRangePicker.propTypes = {

};

DateRangePicker.defaultProps = {
  allowClear: true,
}

export default DateRangePicker;