/*
 * @Author: wufan
 * @Date: 2020-07-09 14:03:09
 * @Last Modified by: mikey.zhaopeng
 * @Last Modified time: 2020-11-25 18:23:40
 * 店铺管理-员工管理
 */
import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import _ from "underscore";
import PageControl from "@/components/PageControl";
import { Button, Table, Tooltip, Modal, message, Row, Col } from "antd";
import { storeRoleEnum } from "@/domains/store-domain/constants";
import StoreService from "@/domains/store-domain/storeService";

import "./EmployeesManagePage.less";
const { confirm } = Modal;
declare var window: any;

function EmployeesManagePage() {
  const [employeeList, setEmployeeList] = useState([
    {
      name: "赵云",
      phone: "18767118672",
      identity: "0",
    },
  ]);
  const [query, setQuery] = useState({
    current: 0,
    size: 10,
    instId: "1837447" || window.currentUserInstInfo.instId,
  });
  const [total, setTotal] = useState(0);
  const [model, setModel] = useState(null);

  useEffect(() => {
    getEmployeeList();
  }, [query]);

  function getEmployeeList() {
    let _query = _.clone(query);
    _query.current = query.current + 1;
    StoreService.getEmployeeList(_query).then((res: any) => {
      console.log(res.result.records);
      setEmployeeList(res.result.records);
      setTotal(res.result.total);
    });
  }

  function parseColumn() {
    return [
      {
        title: "员工",
        dataIndex: "name",
        render: (val: string) => {
          return (
            <div className="coupon-info">
              <span className="title">{val}</span>
            </div>
          );
        },
      },
      {
        title: "手机号",
        dataIndex: "phone",
        key: "phone",
        render: (val: string) => {
          return <div>{val}</div>;
        },
      },
      {
        title: "身份",
        dataIndex: "identity",
        key: "identity",
        render: (val: string = "1") => {
          return <div>{/* {storeRoleEnum[val]} */}</div>;
        },
      },
      {
        title: "操作",
        dataIndex: "operation",
        render: (val: string, record: { identity: string }) => {
          return record.identity === "0" || record.identity === "1" ? (
            <div className="no-operate">-</div>
          ) : (
            <div className="operation">
              <span
                className="opt-item"
                onClick={() => handleEditEmployee(record)}
              >
                编辑
              </span>
              <span className="divider"></span>
              <span
                className="opt-item"
                onClick={() => handleDeleteEmployee(record)}
              >
                删除
              </span>
            </div>
          );
        },
      },
    ];
  }

  function handleEditEmployee(record: object) {}

  function handleDeleteEmployee(record: object) {}

  function handleToAddEmployee() {}

  return (
    <div className=" page coupon-list-page">
      <div className="page-content">
        <div className="content-header">员工管理</div>
        <div className="box">
          <div className="box-header">
          {/* <Row type="flex" justify="space-between" align="top">
            <Col></Col>
            </Row> */}
            <Button
              onClick={() => {
                handleToAddEmployee();
              }}
              type="primary"
              className="add-show-btn"
            >
              添加员工
            </Button>
          </div>
          <div className="box-body">
            <Table
              size={"middle"}
              pagination={false}
              dataSource={employeeList}
              columns={parseColumn()}
              rowKey={(item: any) => item.id}
              bordered
            />
          </div>
          <div className="box-footer">
            <PageControl
              current={query.current}
              pageSize={query.size}
              total={total}
              toPage={(page) => {
                const queryStates = _.clone(query);
                queryStates.current = page;
                setQuery(queryStates);
              }}
            />
          </div>
        </div>
        {model}
      </div>
    </div>
  );
}

export default withRouter(EmployeesManagePage);
