/*
 * @Author: yuananting
 * @Date: 2021-03-29 10:52:26
 * @LastEditors: yuananting
 * @LastEditTime: 2021-04-01 14:01:06
 * @Description: 助学工具-新建试卷-选择题目弹窗
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { Component } from "react";
import { Modal } from "antd";
import CourseCategorySiderTree from "../../components/CourseCategorySiderTree";
import SelectQuestionContent from "../components/SelectQuestionContent";
import "./SelectQuestionModal.less";

class SelectQuestionModal extends Component {
  listRef = React.createRef();
  constructor(props) {
    super(props);
    this.state = {
      selectedCategoryId: null,
    };
  }

  getCategoryIdFromSider = (selectedCategoryId) => {
    if (selectedCategoryId && selectedCategoryId.length > 0) {
      this.setState({ selectedCategoryId: selectedCategoryId[0] });
    }
  };

  render() {
    return (
      <Modal
        destroyOnClose={true}
        title="选择题目"
        visible={true}
        width={1200}
        onOk={() => {
          this.props.setSelectedQuestion(
            this.listRef.current.state.selectQuestionKeys.map((item) => {
              item.questionType = item.questionTypeEnum;
              item.score = 2;
              if (
                ["MULTI_CHOICE", "GAP_FILLING", "INDEFINITE_CHOICE"].includes(
                  item.questionTypeEnum
                )
              ) {
                item.portionScore = 0;
              }
              return item;
            })
          );
        }}
        onCancel={this.props.close}
        className="select-question-modal"
      >
        <div className="box content-body">
          <div
            style={{ borderRight: "0.5px solid #EEEEEE", paddingRight: "4px" }}
          >
            <div className="sider">
              <CourseCategorySiderTree
                fromModule="QUESTION_MODAL"
                getSelectedCategoryId={this.getCategoryIdFromSider.bind(this)}
              />
            </div>
          </div>
          <div className="content">
            <SelectQuestionContent
              ref={this.listRef}
              selectedCategoryId={this.state.selectedCategoryId}
            />
          </div>
        </div>
      </Modal>
    );
  }
}

export default SelectQuestionModal;
