import React from 'react';
import { withRouter } from "react-router-dom";
import { Tabs } from 'antd';
import Breadcrumbs from "@/components/Breadcrumbs";
import EmployeeShareData from './components/EmployeeShareData';
import UserLearningData from './components/UserLearningData';

import './LearningData.less';

class LearningData extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      
    }
  }
  render() {
    return (
      <div className="page plan-learn-data-list">
        <Breadcrumbs
          navList="学习数据"
          goBack={() => {
            RCHistory.goBack();
          }}
        />
        <div className="plan-info">
          <div className="plan-intro">
            <div className="plan-img-con">
              <img src="https://image.xiaomaiketang.com/xm/YNfi45JwFA.png"/>
            </div>
            <div>
              <div className="plan-name">
                六年级数学精品公开课快来参加二十个字展示
              </div>
              <div className="create-course">
                <span className="createUser">创建人：张老师</span>
                <span className="split">|</span>
                <span className="course-total">课程总数量：88</span>
              </div>
              <div className="create-time">创建时间：2020-01-01 09:00</div>
            </div>
          </div>
          <div className="join">
            <div className="number">1999</div>
            <div className="text">参培人数</div>
          </div>
        </div>
        <div className="box">
          <Tabs defaultActiveKey="employeeShareData">
            <Tabs.TabPane tab="员工分享数据" key="employeeShareData">
                <EmployeeShareData/>
            </Tabs.TabPane>
            <Tabs.TabPane tab="用户学习数据" key="userLearningData">
                <UserLearningData/>
            </Tabs.TabPane>
          </Tabs>
        </div>

      </div>
    )
  }
}

export default withRouter(LearningData);