import React from 'react';
import { withRouter } from "react-router-dom";
import {Table, Modal,Input,message} from 'antd';
import { PageControl } from "@/components";
import './EmployeeShareData.less';

const { Search } = Input;
const UserRole = {
  StoreManager: {
    name: "店铺管理员"
  },
  CloudManager: {
    name:"管理员"
  },
  CloudOperator: {
    name:'运营师'
  },
  CloudLecturer: {
    name:"讲师"
  },
};
class EmployeeShareData extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      dataSource:[],
      size:10,
      query: {
        current: 1,
      },
      totalCount:0,
    }
  }

  handleFetchDataList = ()=>{

  }
   // 请求表头
  parselumns = () => {
    const columns = [
      {
        title: '员工',
        key: 'storeUserName',
        dataIndex: 'storeUserName',
        render: (val, record) => {
          return (
            <div>
              {val}
            </div>
          )
        }
      },
      {
        title: '角色',
        key: 'roleEnum',
        dataIndex: 'roleEnum',
        render: (val, record) => {
          return (
            <div>
              {UserRole[val].name}
            </div>
          )
        }
      },
      {
        title: '手机号',
        key: 'storeUserPhone',
        dataIndex: 'storeUserPhone',
        render: (val, record) => {
          return (
            <div>
              {val}
            </div>
          )
        }
      },
      {
        title: '最近分享成功时间',
        key: 'recentlyForwardTime',
        dataIndex: 'recentlyForwardTime',
        sorter:true,
        render: (val, record) => {
          return (
            <div>
              {formatDate('YYYY-MM-DD H:i', val)}
            </div>
          )
        }
      },
      {
        title: '学习人数',
        key: 'learnNum',
        dataIndex: 'learnNum',
        sorter:true,
        render: (val, record) => {
          return (
            <div>
              {val}
            </div>
          )
        }
      },
      {
        title: '已学完',
        key: 'learnFinishNum',
        dataIndex: 'learnFinishNum',
        sorter:true,
        render: (val, record) => {
          return (
            <div>
              {val}
            </div>
          )
        }
      },
      {
        title: '未学完',
        key: 'learnNoFinishNum',
        dataIndex: 'learnNoFinishNum',
        sorter:true,
        render: (val, record) => {
          return (
            <div>
              {val}
            </div>
          )
        }
      },
      {
        title: '操作',
        key: 'operate',
        dataIndex: 'operate',
        render: (val, record) => {
          return (
            <span>数据详情</span>
          )
        }
      }

    ];
    return columns;
  }
  render() {
    const { dataSource,query,size,totalCount} = this.state;
    return (
      <div className="employee-share-data">
        <div className="search-container">
            <Search placeholder="搜索员工姓名手机号"  style={{ width: 200 }}  enterButton={<span className="icon iconfont">&#xe832;</span>}/>
        </div>
        <div>
              <Table
                  rowKey={record => record.id}
                  dataSource={dataSource}
                  columns={this.parselumns()}
                  pagination={false}
              />
              {dataSource.length >0 &&
                <div className="box-footer">
                    <PageControl
                        current={query.current - 1}
                        pageSize={size}
                        total={totalCount}
                        toPage={(page) => {
                            const _query = {...query, current: page + 1};
                            this.setState({
                              query:_query
                            },()=>{ this.handleFetchDataList()})
                        }}
                    />
                </div>
                }
        </div>
      </div>
    )
  }
}

export default withRouter(EmployeeShareData);