/*
 * @Author: zhangleyuan
 * @Date: 2021-02-20 16:46:46
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2021-03-02 15:55:04
 * @Description: 描述一下
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useState, useRef, useEffect } from 'react';
import { Table, Modal, message , Tooltip,Switch,Dropdown} from 'antd';
import { withRouter } from 'react-router-dom';
import { PageControl } from "@/components";
import PlanService from "@/domains/plan-domain/planService";
import SharePlanModal from '../modal/SharePlanModal';
import {LIVE_SHARE} from '@/domains/course-domain/constants';
import User from '@/common/js/user';
import './PlanList.less';

const { confirm } = Modal;
const userRole =  User.getUserRole();
function PlanList(props) {
    const [sharePlanModal, setSharePlanModal] = useState(null);
   
    function parseColumns(){
        const columns = [
            {
                title: '培训计划',
                key: 'planName',
                dataIndex: 'planName',
                width:'15%',
                render: (val, record) => {
                    return (
                        <div className="plan__name">
                            {val}
                        </div>
                    )
                }
            },
            {
                title: '课程总数量',
                key: 'courseNum',
                dataIndex: 'courseNum',
                width: '10%',
                render: (val, record) => {
                return (
                    <div className="course-number">
                        {val}
                    </div>
                )
                }
            },
            {
                title: '当前状态',
                width: '10%',
                dataIndex: "status",
                render: (val, item, index) => {
                    return  (
                        <Switch  defaultChecked={item.enableState==="YES"? true:false}  onChange={()=>changeEnableState(item)} disabled={(userRole === "CloudManager" || userRole === "StoreManager")?false:true}/>
                    ) 
                },
            },
            {
                title: '创建人',
                key: 'createName',
                dataIndex: 'createName',
                width: '10%',
                render: (val) => {
                return (
                    <div className="create-name">
                        {val}
                    </div>
                )
                }
            },
            {
                title: '创建时间',
                width: "10%",
                key: 'created',
                dataIndex: 'created',
                sorter: true,
                render: (val) => {
                return  formatDate('YYYY-MM-DD H:i', val) 
                }
            },
            {
                title: '更新时间',
                width: "10%",
                key: 'updated',
                dataIndex: 'updated',
                sorter: true,
                render: (val) => {
                return formatDate('YYYY-MM-DD H:i', val) 
                }
            },
            {
                title: '参培人数',
                width: "10%",
                key: 'cultureCustomerNum',
                dataIndex: 'cultureCustomerNum',
                sorter: true,
                render: (val) => {
                    return ( 
                        <div className="join-number">
                            {val}
                        </div>
                    ) 
                }
            },
            {
                title: '操作',
                key: 'operate',
                dataIndex: 'operate',
                width: '25%',
                render: (val, record) => {
                    return (
                        <div className="operate">
                            <div className="operate__item" onClick={()=>toLearningDataPage(record)}>学习数据</div>
                            <span className="operate__item split"> | </span>
                            <div className="operate__item" onClick={() => {handleShowShareModal(record); }}>分享</div>
                            <span className="operate__item split"> | </span>
                            {(userRole === "CloudManager" || userRole === "StoreManager") &&
                                <Dropdown overlay={renderMoreOperate(record)}>
                                    <span className="more-operate">
                                    <span className="operate-text">更多</span>
                                    <span
                                        className="iconfont icon"
                                        style={{ color: "#5289FA" }}
                                    >
                                        &#xe824;
                                    </span>
                                    </span>
                                </Dropdown>
                            }
                        </div>
                    )
                }
            }
        ];
        return columns;
    }
    function renderMoreOperate(item){
        return (
            <div className="live-course-more-menu">
                
                <div  className="operate__item"
                onClick={()=>toEditPlanPage(item)}
                >编辑</div>
                <div
                className="operate__item"
                >删除</div>
            </div>
        )
    }
    function handleChangeTable(pagination, filters, sorter){
        const { columnKey, order } = sorter;
        const { query } = props;
        let  _columnKey;
        let _order;

        // 按创建时间升序排序
        if (columnKey === 'created' && order === 'ascend') {_columnKey="UPDATED"; _order = 'SORT_ASC'; }
        // 按创建时间降序排序
        if (columnKey === 'created' && order === 'descend') { _columnKey="UPDATED"; _order = 'SORT_DESC';}
        // 按更新时间升序排序
        if (columnKey === 'updated' && order === 'ascend') { _columnKey="CREATED"; _order = 'SORT_ASC'; }
        // 按更新时间降序排序
        if (columnKey === 'updated' && order === 'descend') { _columnKey="CREATED"; _order = 'SORT_DESC'; }
        // 按更新时间升序排序
        if (columnKey === 'cultureCustomerNum' && order === 'ascend') { _columnKey="CUSTOMER_NUM"; _order = 'SORT_ASC'; }
        // 按更新时间降序排序
        if (columnKey === 'cultureCustomerNum' && order === 'descend') { _columnKey="CUSTOMER_NUM"; _order = 'SORT_DESC'; }
        const _query = {
          ...query,
          sortMap:{}
        };
        _query.sortMap[_columnKey]=_order;
        props.onChange(_query);
    }
        // 显示分享弹窗
    function handleShowShareModal(item) {
        const htmlUrl = `${LIVE_SHARE}live_detail?id=${User.getStoreId()}`;
        const longUrl = htmlUrl
        const shareData = { ...item, longUrl };
        const sharePlanModal = (
            <SharePlanModal
                data={shareData}
                type="liveClass"
                close={() => {
                    setSharePlanModal(null)
                   
                }}
            />
        )
        setSharePlanModal(sharePlanModal)
    }
     //改变上架状态
    function changeEnableState(record){
        let _enableState = record.enableState
        if(_enableState==='NO'){
            //   _enableState = "YES";
            const params={
                "planId": record.planId,
                "enableState":"YES"
            }
            PlanService.updateStateTrainingPlan(params).then((res)=>{
                if(res.success){   
                    //   if(_enableState === "YES"){
                        record.enableState = "YES";
                        message.success("已启用此计划");
                    //   }
                }
            }) 
        }else{
            //   _enableState = "NO";
            //   item.enableState = "YES";
            return confirm({
                title: "确定要禁用培训计划吗？",
                content: "禁用后，培训计划不再支持新用户加入，已参与培训的用户可继续培训",
                icon: (
                <span className="icon iconfont default-confirm-icon">&#xe839; </span>
                ),
                okText: "确定",
                okType: "danger",
                cancelText: "取消",
                onOk: () => {
                    const params={
                        "planId": record.planId,
                        "enableState":"NO"
                    }
                    PlanService.updateStateTrainingPlan(params).then((res)=>{
                        if(res.success){
                            //   if(_enableState === "NO"){
                                record.enableState = "NO";
                                message.success("已禁用此计划");
                            //   }
                        }
                    })
                },
            });
        }
    } 
    
    function toEditPlanPage(item){
        window.RCHistory.push({
            pathname: `/create-plan?type=edit&id=${item.planId}`,
        })
    }
    function toLearningDataPage(item){
        window.RCHistory.push({
            pathname: `/learning-data?id=${item.planId}`,
        })
    }
    return (
        <div className="plan-list">
            <Table
                rowKey={record => record.id}
                dataSource={props.planListData}
                columns={ parseColumns() }
                pagination={false}
                onChange={handleChangeTable}
                bordered
            />
            <div className="box-footer">
                <PageControl
                    current={props.query.current - 1}
                    pageSize={props.query.size}
                    total={props.totalCount}
                    toPage={(page) => {
                        const _query = {...props.query, current: page + 1};
                        props.onChange(_query)
                    }}
                />
            </div>  
            {sharePlanModal }
        </div>
    )
  }
  
  export default withRouter(PlanList);