import React from 'react';
import { withRouter } from "react-router-dom";
import {Table, Modal,Input,message} from 'antd';
import { PageControl } from "@/components";
import UserLearningDataFilter from './UserLearningDataFilter';
import './EmployeeShareData.less';
import Item from 'antd/lib/list/Item';

const { Search } = Input;
const LearnState = {
  UN_PLAY: {
    text: "未开始"
  },
  UNDER_WAY: {
    text:"进行中"
  },
  FINISH : {
    text:'已完成'
  }
};

class UserLearningData extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      dataSource:[],
      size:10,
      query: {
        current: 1,
      },
      totalCount:0,
    }
  }

  handleFetchDataList = ()=>{

  }
   // 请求表头
  parselumns = () => {
    const columns = [
      {
        title: '用户',
        key: 'storeCustomerName',
        dataIndex: 'storeCustomerName',
        render: (val, record) => {
          return (
            <div>
              {val}
            </div>
          )
        }
      },
      {
        title: '学习状态',
        key: 'roleEnum',
        dataIndex: 'roleEnum',
        render: (val, record) => {
          return (
            <div>
              {LearnState[val].text}
            </div>
          )
        }
      },
      {
        title: '负责人',
        key: 'userNameList',
        dataIndex: 'userNameList',
        render: (val, record) => {
          return (
            <div>
              {record.userNameList.map((item,index)=>{
                 return <span>{item} { (index < record.userNameList.length-1)&&(<span> 、</span>)} </span>
              })}
            </div>
          )
        }
      },
      {
        title: '最近学习时间',
        key: 'latelyLearnTime',
        dataIndex: 'latelyLearnTime',
        sorter:true,
        render: (val, record) => {
          return (
            <div>
              {formatDate('YYYY-MM-DD H:i', val)}
            </div>
          )
        }
      },
      {
        title: '开始学习时间',
        key: 'startLearnTime',
        dataIndex: 'startLearnTime',
        sorter:true,
        render: (val, record) => {
          return (
            <div>
              {formatDate('YYYY-MM-DD H:i', val)}
            </div>
          )
        }
      },
      {
        title: '学习进度',
        key: 'learnNum',
        dataIndex: 'learnNum',
        sorter:true,
        render: (val, record) => {
          return (
            <div>
              <span>{record.courseFinishNum}</span>
              <span>/</span>
              <span>{record.courseNum}</span>
            </div>
          )
        }
      },
      {
        title: '操作',
        key: 'operate',
        dataIndex: 'operate',
        render: (val, record) => {
          return (
            <div>
              <span>学习详情</span>
              <span>|</span>
              <span>解绑</span>
            </div>
          )
        }
      }
    ];
    return columns;
  }
  render() {
    const { dataSource,query,size,totalCount} = this.state;
    return (
      <div className="user-learning-data">
        <div className="search-container">
          <UserLearningDataFilter/>
        </div>
        <div>
              <Table
                  rowKey={record => record.id}
                  dataSource={dataSource}
                  columns={this.parselumns()}
                  pagination={false}
              />
              {dataSource.length >0 &&
                <div className="box-footer">
                    <PageControl
                        current={query.current - 1}
                        pageSize={size}
                        total={totalCount}
                        toPage={(page) => {
                            const _query = {...query, current: page + 1};
                            this.setState({
                              query:_query
                            },()=>{ this.handleFetchDataList()})
                        }}
                    />
                </div>
              }
        </div>
      </div>
    )
  }
}

export default withRouter(UserLearningData);