import React from 'react';
import {Table, Modal,Input} from 'antd';
import { PageControl } from "@/components";
import StoreService from "@/domains/store-domain/storeService";
import User from '@/common/js/user'
import './SelectOperatorModal.less';
import _ from "underscore";
const { Search } = Input;
class SelectOperatorModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      dataSource:[],
      size:10,
      query: {
        current: 1,
      },
      totalCount:0,
      selectOperatorList:props.selectOperatorList
    };
  }
  componentDidMount() {
    this.handleFetchDataList();
  }
 
   // 获取运营师列表
  handleFetchDataList = () => {
    const {query,size,totalCount} = this.state
    const params ={
      ...query,
      size,
      roleCodes:['CloudOperator']
    }
    StoreService.getStoreUserBasicPage(params).then((res) => {
      const { result = {} } = res ;
      const { records = [], total = 0 } = result;
      this.setState({
        dataSource: records,
        totalCount: Number(total)
      });
    });
  }
  handleChangNickname = (value)=>{
    const isPhone = (value || '').match(/^\d+$/);
    const { query } =  this.state;
    if(isPhone){
      query.phone = value;
      query.nickName = null;
    }else{
      query.nickName = value;
      query.phone = null;
    }
    query.current = 1;
    this.setState({
      query
    })
  }

  onShowSizeChange = (current, size) => {
    if (current == size) {
      return
    }
    this.setState({
      size
    },()=>{this.handleFetchDataList()})
  }

  // 请求表头
  parseColumns = () => {
    const columns = [
      {
        title: '姓名',
        key: 'nickName',
        dataIndex: 'nickName'
      },
      {
        title: '手机号',
        key: 'phone',
        dataIndex: 'phone'
      }
    ];
    return columns;
  }
  selectOperator = (record,selected) =>{
    const {selectOperatorList} = this.state;
    let _list = [];
    if (selected || !_.find(selectOperatorList, (item) => item.id == record.id)) {
      _list = _.uniq(selectOperatorList.concat([record]), false, (item) => item.id);
    } else {
      _list = _.reject(selectOperatorList, (item) => item.id === record.id);
    }
    this.setState({selectOperatorList:_list});
  }
  render() {
    const { size,dataSource,totalCount,query,selectOperatorList} = this.state;
    const { visible } = this.props;
    return (
        <Modal
          title="选择运营师"
          onCancel={this.props.onClose}
          maskClosable={false}
          visible={visible}
          className="select-operator-modal"
          closable={true}
          width={800}
          onOk={() => this.props.onSelect(selectOperatorList) } 
        >
          <div className="search-container">
            <Search placeholder="搜索运营师/手机号"  style={{ width: 200 }}  onChange={(e) => { this.handleChangNickname(e.target.value)}}  onSearch={ () => { this.handleFetchDataList()}} />
          </div>
          <div>
            <Table
              rowKey={record => record.id}
              dataSource={dataSource}
              columns={this.parseColumns()}
              pagination={false}
              rowSelection={{
                type: 'checkbox',
                selectedRowKeys: _.pluck(selectOperatorList, 'id'),
                onSelect: (record, selected) => {
                  this.selectOperator(record, selected)
                },
                onSelectAll: (selected, _selectedRows, changeRows) => {
                  let _list = [];
                  if (selected) {
                    _list = _.uniq(selectOperatorList.concat(changeRows), false, (item) => item.id);
                  } else {
                    _list = _.reject(selectOperatorList, (item) => _.find(changeRows, (data) => data.id === item.id));
                  }
                  this.setState({selectOperatorList:_list});
                },
              }}
            />
            {dataSource.length >0 &&
              <div className="box-footer">
                <PageControl
                  current={query.current - 1}
                  pageSize={size}
                  total={totalCount}
                  toPage={(page) => {
                    const _query = {...query, current: page + 1};
                    this.setState({
                      query:_query
                    },()=>{ this.handleFetchDataList()})
                  }}
                  onShowSizeChange={this.onShowSizeChange}
                />
              </div>
            }
          </div>
        </Modal>
    )
  }
}

export default SelectOperatorModal;