
import React from 'react';
import { Modal, Button } from "antd";
import "./DownloadLiveModal.less"

class DownloadLiveModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      image: 'https://image.xiaomaiketang.com/xm/K2sJJHG3pa.png',
      tip: '直播上课需要使用客户端，请先下载并安装。',
      text: '安装直播客户端',
      type: 'pre',
    }
  }
  render() {
    const { url } = this.props;
    const { image, tip, text, type } = this.state;
    return <Modal
      visible={true}
      title="下载客户端"
      className="download-live-modal"
      footer={null}
      onCancel={() => {
        this.props.onCancel();
      }}
      closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
    >
     <img  className="download-image" src={image} alt="" />
      <p className="download-tip">{tip}</p>
      <Button
        type="primary"
        className="download-button"
        onClick={() => {
          if (type === 'pre') {
            url && window.open(url);
            this.setState({
              image: 'https://image.xiaomaiketang.com/xm/wPwRdaa7MM.png',
              tip: '安装完成后，再次打开即可开始直播。',
              text: '我知道了',
              type: 'finish',
            })
          } else {
            this.props.onCancel();
          }
        }}
      >{text}</Button>
    </Modal>
  }
}

export default DownloadLiveModal;