import React, { useEffect, useState } from "react";
import { DatePicker, TimePicker, Select } from 'antd';
import StoreService from "@/domains/store-domain/storeService";
import "./AddLiveClassInfoWorkWX.less";
import GraphicsEditor from "./GraphicsEditor";
import moment from "moment";
const { Option } = Select;

const defaultTeacherQuery = {
    size: 15,
    current: 1,
    nickName:null
  }

export default function AddLiveClassInfoWorkWX(props) {

    const [teacherQuery, setTeacherQuery] = useState(defaultTeacherQuery)
    const [teacherList, setTeacherList] = useState([])
    const [introduce, setIntroduce] = useState()
    const [duration, setDuration] = useState(0)
    const [cusTime, setCusTime] = useState(false)

    const [beginDate, setBeginDate] = useState(moment().startOf('day').valueOf())
    const [endDate, setEndDate] = useState(moment().startOf('day').valueOf())

    useEffect(()=> {
        getTeacherList()
    },[])

    //开始时间
    function onBeginDateChange(date, dateString) {
        setBeginDate(date.startOf('day').valueOf())
    }

    function onBeginDateOK(date) {
        console.log(date)
    }

    function onBeginTimeChange(date, dateString) {
        // props.onChange("beginTime",date.valueOf())
    }

    function onBeginTimeOK(time) {
        props.onChange("beginTime",beginDate+(time.hour()*60+time.minute())*60*1000)
    }
    //结束时间
    function onEndDateChange(date, dateString) {
        setEndDate(date.startOf('day').valueOf())
    }

    function onEndDateOK(date) {

    }

    function onEndTimeChange(date, dateString) {
        // props.onChange("endTime",date.valueOf())
    }

    function onEndTimeOK(time) {
        props.onChange("endTime",endDate+(time.hour()*60+time.minute())*60*1000)
    }

    function onDurationChange(value, option) {
        if (value === "0") {
            setCusTime(true)
            return
        }
        let d = Number(value)*60*1000;
        setDuration(d)
        props.onChange("duration",d)
    }

    function onTeacherChange(value, option) {
        props.onChange("teacherId",value)
    }

    function onRemindChange(value, option) {
        props.onChange("remindTime",Number(value)*60)
    }

    function onChangeIntro(val) {
        props.onChange("intro",val)
    }

    function getTeacherList(current = 1) {
        const _query = {
          ...teacherQuery,
          current,
          size:15
        };
        StoreService.getStoreUserBasicPage( _query).then((res) => {
            const { result = {} } = res;
            const { records = [], total = 0, hasNext } = result;
            const list = current > 1 ? teacherList.concat(records) : records;
            setTeacherList(list)
            setTeacherQuery({..._query,hasNext})
        });
    }

    return (
        <div className="AddLiveClassInfoWorkWX">
            <div className="begin-time item">
                <span className="label"><span className="require">*</span>开始时间：</span>
                <DatePicker defaultValue={moment()} onChange={onBeginDateChange} onOk={onBeginDateOK} />
                <TimePicker defaultValue={moment()} onChange={onBeginTimeChange} onOk={onBeginTimeOK} format="HH:mm" />
            </div>
            <div className="duration-time item">
                {
                    cusTime ? (
                        <>
                        <span className="label"><span className="require">*</span>结束时间：</span>
                        <DatePicker defaultValue={moment()} onChange={onEndDateChange} onOk={onEndDateOK} />
                        <TimePicker defaultValue={moment()} onChange={onEndTimeChange} onOk={onEndTimeOK} format="HH:mm" />
                        </>
                    ) : (
                        <>
                        <span className="label"><span className="require">*</span>时长：</span>
                        <Select onChange={onDurationChange} defaultValue="60">
                            <Option value="30">0.5小时</Option>
                            <Option value="60">1.0小时</Option>
                            <Option value="120">2.0小时</Option>
                            <Option value="180">3.0小时</Option>
                            <Option value="0">自定义结束时间</Option>
                        </Select>
                        </>
                    )
                }

            </div>
            <div className="teacher item">
                <span className="label"><span className="require">*</span>讲师：</span>
                <Select 
                onChange={onTeacherChange} 
                style={{width:"240px"}} 
                placeholder="请选择讲师"
                >
                    {
                    _.map(teacherList, (item, index) => {
                        return (
                        <Select.Option value={item.userId} key={item.userId}>{item.nickName}</Select.Option>
                        );
                    })
                    }
                </Select>
            </div>
            <div className="remind-time item">
                <span className="label"><span className="require">*</span>提醒时间：</span>
                <Select onChange={onRemindChange} defaultValue="0" style={{width:"100px"}}>
                    <Option value="0">无</Option>
                    <Option value="5">5分钟前</Option>
                    <Option value="60">1小时前</Option>
                    <Option value="1440">1天前</Option>
                </Select>
            </div>
            <div className="introduce item">
                <span className="label">直播简介：</span>
                <div className="intro-edit">
                    <GraphicsEditor
                    id='intro'
                    isIntro={true}
                    maxLimit={1000}
                    detail={{
                      content: introduce,
                    }}
                    onChange={(val) => {
                      onChangeIntro(val);
                    }}
                    ></GraphicsEditor>
                </div>
            </div>
        </div>
    )
}