import React, { useState } from "react";
import "./LiveModeSelect.less"
import { createPortal } from "react-dom";

interface LiveModeSelectProps {
    isShow: boolean;
    onClose: ()=> void;
    onSelected: (type: number)=> void;
}

export default function LiveModeSelect(props: LiveModeSelectProps) {

    const handleSelect0 = (e: React.MouseEvent<HTMLDivElement>)=> {
        const { onSelected } = props
        onSelected(0)
    }
    const handleSelect1 = (e: React.MouseEvent<HTMLDivElement>)=> {
        const { onSelected } = props
        onSelected(1)
    }
    const handleClose = (e: React.MouseEvent<HTMLDivElement>)=> {
        props.onClose()
    }

    return createPortal(
        <div className={`livemode-select${props.isShow ? "":" livemode-select-none"}`}>
            <div className="dialog">
                <div className="header">
                <div className="title">选择直播方式</div>
                <span className="icon iconfont close" onClick={handleClose}>&#xe6ef;</span>
                </div>
                <div className="content">
                <div className="item">
                    <div className="logo xiaomai-logo"></div>
                    <div className="item-title">小麦直播</div>
                    <div className="des">通过小麦企学院“PC客户<br/>端”进行直播</div>
                    <div className="button" onClick={handleSelect0}>立即创建</div>
                </div>
                <div className="item">
                    <div className="logo qiwei-logo"></div>
                    <div className="item-title">企微直播</div>
                    <div className="des">通过“企业微信APP”进行<br/>直播进行直播</div>
                    <div className="button" onClick={handleSelect1}>立即创建</div>
                </div>
                </div>
            </div>
        </div>,
        document.body
    )
}