import React, { useState, useEffect } from 'react';
import { Modal, Button, Input} from 'antd';
import _ from 'underscore';
import './ChangePhoneModal.less';
import Form from 'antd/lib/form/Form';


interface changePhoneModalProps {
    onClose:() => void,
    onConfirm:(e:any) => void
}

function ChangePhoneModal(props: changePhoneModalProps) {
    const { onClose,onConfirm } = props;
    const [newPhone,setNewPhone]  = useState('');
    const [phoneVerify,setPhoneVerify] = useState('');
    const [codeText, setCodeText] = useState('发送验证码'); 
     //Todo
     const [errorMessageText,setErrorMessageText] =  useState('验证码有误');

    useEffect(() => {
     
    })
    function handleConfirm():any{
        onClose();
    }
    return (
        <Modal
            visible={true}
            title="更换手机号"
            width={448}
            onCancel={onClose}
            className="change-phone-modal"
            footer={[
                <Button
                    id='cancel_allot_btn'
                    key="back" onClick={onClose}>取消</Button>,
                <Button
                    id='confirm_allot_btn'
                    key="submit"
                    type="primary"
                    onClick={() => {
                        handleConfirm()
                    }}>
                    确认
                </Button>
            ]}
        >
            <div className="desc">请输入新的手机号</div>
            <div className="new-phone-content"> 
                <Input
                    type="text"
                    name="newPhone"
                    placeholder="请输入新手机号"
                    value={newPhone}
                    onChange={(e) => { setNewPhone(e.target.value) }}
                    style={{ width:200,height:32}}
                />
            </div>
            <div className="verify-content"> 
                <Input
                    type="text"
                    name="phoneVerify"
                    placeholder="请输入手机号"
                    value={newPhone}
                    onChange={(e) => { setNewPhone(e.target.value) }}
                    style={{ width:200,height:32}}
                />
                <span className="send-code">{codeText}</span>
            </div>
            <div className="error-message">{errorMessageText}</div>
        </Modal>
    )
}

export default ChangePhoneModal;