import React, { useState, useEffect } from 'react';
import { Modal, Button, Input} from 'antd';
import _ from 'underscore';
import './ChangePhoneModal.less';
import Form from 'antd/lib/form/Form';


interface changePhoneModalProps {
    onClose:() => void,
    onConfirm:(e:any) => void
}

function ChangePhoneModal(props: changePhoneModalProps) {
    const { onClose,onConfirm } = props;
    const [newPhone,setNewPhone]  = useState('');
    const [phoneVerify,setPhoneVerify] = useState('');
    const [codeText, setCodeText] = useState('发送验证码'); 
    const [waitStatus, setWaitStatus] = useState(false); // 验证码是否在倒计时
    const [newPhoneError,setNewPhoneError] =  useState(false);
    const [phoneVerifyError,setPhoneVerifyError] =  useState(false);
     //Todo
    const [errorMessageText,setErrorMessageText] =  useState('');

    useEffect(() => {
     
    })

    // function checkPhone():any{
      
    // }
    function checkPhoneVerify():any{
        if(!phoneVerify){
            setErrorMessageText('请输入验证码'); 
            setPhoneVerifyError(true);
            return;
        }
    }
    function handleSendCode():any{
        if (waitStatus) return;
        if(!newPhone){
            setErrorMessageText('请输入手机号'); 
            setNewPhoneError(true);
            return;
        }
        if(newPhone.length < 11){
            setErrorMessageText('请输入11位手机号'); 
            setNewPhoneError(true);  
            return; 
        }
         let timer:any;
         timeSub(60,0);
         function timeSub(waitTime:number, unit:number):any{
             clearTimeout(timer);
             timer = setTimeout(function () {
                 if (waitTime == 0) {
                 setCodeText('发送验证码')
                 setWaitStatus(false)
                 clearTimeout(timer);
                 } else {
                     setCodeText(`${waitTime}秒后重发`)
                     setWaitStatus(true)
                     timeSub(--waitTime, 1000);
                 }
             }, unit || 0);
         }
    }

    function handleConfirm():any{
        if(!newPhone){
            setErrorMessageText('请输入手机号'); 
            setNewPhoneError(true);
            return;
        }
        if(newPhone.length < 11){
            setErrorMessageText('请输入11位手机号'); 
            setNewPhoneError(true);  
            return; 
        }
        if(!phoneVerify){
            setErrorMessageText('请输入验证码'); 
            setPhoneVerifyError(true); 
            return;  
        }
        onClose();
    }
    return (
        <Modal
            visible={true}
            title="更换手机号"
            width={448}
            onCancel={onClose}
            className="change-phone-modal"
            footer={[
                <Button
                    id='cancel_allot_btn'
                    key="back" onClick={onClose}>取消</Button>,
                <Button
                    id='confirm_allot_btn'
                    key="submit"
                    type="primary"
                    onClick={() => {
                        handleConfirm()
                    }}>
                    确认
                </Button>
            ]}
        >
            <div className="desc">请输入新的手机号</div>
            <div className="new-phone-content"> 
                <Input
                    type="number"
                    maxLength={11}
                    name="newPhone"
                    placeholder="请输入新手机号"
                    value={newPhone}
                    className={ newPhoneError ? 'error-input' : ''}
                    onChange={(e) => { 
                        setNewPhone(e.target.value);
                        setNewPhoneError(false);
                        setErrorMessageText('')
                    }}
                    style={{ width:200,height:32}}
                />
            </div>
            <div className="verify-content"> 
                <Input
                    type="number"
                    name="phoneVerify"
                    maxLength={4}
                    placeholder="请输入验证码"
                    value={phoneVerify}
                    className={ phoneVerifyError ? 'error-input' : ''}
                    onChange={(e) => { 
                        setPhoneVerify(e.target.value);
                        setPhoneVerifyError(false);
                        setErrorMessageText('')
                    }}
                    style={{ width:200,height:32}}
                />
                <span className="send-code"  
                onClick={() => {
                    handleSendCode();
                }}>{codeText}</span>
            </div>
            <div className="error-message">{errorMessageText}</div>
        </Modal>
    )
}

export default ChangePhoneModal;