/*
 * @Author: wufan
 * @Date: 2020-07-09 14:03:09
 * @Last Modified by: mikey.zhaopeng
 * @Last Modified time: 2020-11-28 13:53:12
 * 店铺管理-员工管理
 */
import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import _ from "underscore";
import PageControl from "@/components/PageControl";
import { CheckBox } from "@/components";
import { Button, Table, Tooltip, Modal, message, Row, Col, Input } from "antd";

import StoreService from "@/domains/store-domain/storeService";


import "./CourseCatalogPage.less";
const { confirm } = Modal;
const { Search } = Input;

declare var window: any;
interface RecordTypes {
 storeUserId: string,
 role: string
}

function CourseCatalogPage() {
  const [courseCatalogList, setCourseCatalogList] = useState([
    {
      key: 1,
      name: 'John Brown',
      type: 'parent',
      children: [
        {
          key: 11,
          name: 'John Brown',
          type: 'child'
        },
        {
          key: 12,
          name: 'John Brown',
          type: 'child'
        }
      ]  
    },
    {
      key: 2,
      name: 'Jim Green',
      type: 'parent',
      children: [
        {
          key: 11,
          name: 'John Brown',
          type: 'child'
        },
        {
          key: 12,
          name: 'John Brown',
          type: 'child'
        }
      ]  
    },
    {
      key: 3,
      name: 'Not Expandable',
      type: 'parent',
      children: [
        {
          key: 11,
          name: 'John Brown',
          type: 'child'
        },
        {
          key: 12,
          name: 'John Brown',
          type: 'child'
        }
      ]  
    },
    {
      key: 4,
      name: 'Joe Black',
      type: 'parent',
      children: [
        {
          key: 11,
          name: 'John Brown',
          type: 'child'
        },
        {
          key: 12,
          name: 'John Brown',
          type: 'child'
        }
      ]  
    },
  ]);

  const [query, setQuery] = useState({
    current: 0,
    size: 10,
    name: "",
    phone: "",
    identity: "ALL",
    instId: "1837447" || window.currentUserInstInfo.instId,
  });
  
  const [total, setTotal] = useState(0);

  useEffect(() => {
   
  }, [query]);

  function parseColumn():any{
    return [
        { title: '分类名称', 
        dataIndex: 'name', 
        key: 'name',
        },
        {
          title: '操作',
          dataIndex: 'action',
          key: 'action',
          width:300,
          render: (val: string, record: any) => {
            return (
              <div className="operation">
                  { record.type==="parent" && 
                    <>
                      <span
                        className="add"
                      >
                        添加子分类
                      </span>
                      <span className="divider-line">{" | "}</span>
                    </>
                  }
                 
                  <span
                  >
                  编辑
                  </span>
                  <span className="divider-line">{" | "}</span>
                  <span
                  >
                  删除
                  </span>
            </div>
            )

          },
        },
    ]
  }
  return (
    <div className=" page employee-manage-page">
      <div className="page-content">
        <div className="content-header">员工管理</div>
        <div className="box">
          <div className="box-header">
            <Button
              type="primary"
              className="add-show-btn"
            >
              添加分类
            </Button>
          </div>
          <div className="box-body">

            <Table
                columns={ parseColumn() }
                pagination={false}
                expandable={{
                  rowExpandable: record => record.name !== '还未添加子分类',
                }}
                dataSource={courseCatalogList}
            />
          </div>
          <div className="box-footer">
            <PageControl
              current={query.current}
              pageSize={query.size}
              total={total}
              toPage={(page) => {
              
              }}
            />
          </div>
        </div>
        {/* {
            isModalOpen && <EmployeeAddOrEditModal  isOpen={isModalOpen} choosedItem={choosedItem} onClose={()=>{setIsModalOpen(false)}}/>
        } */}
      </div>
    </div>
  );
}

export default withRouter(CourseCatalogPage);
