import React, { useState, useRef, useEffect } from 'react'
import { Select } from 'antd';
import StoreService from "@/domains/store-domain/storeService";

export default function ExaminationManager(props: any) {
    const queryInit: any = {
        planName: ''
    }

    const teacherQueryInit: any = {};
    const [teacherQuery, setTeacherQuery] = useState({
        current:1,
        size: 10,
        roleCodes:props.roleCodes
    });
    const [teacherList, setTeacherList] = useState([]);
    const [hasNext, setHasNext] = useState(true);

    const teacherQueryRef = useRef({})

    useEffect(() => {
        teacherQueryRef.current = teacherQuery;
        getTeacherList()
    }, [teacherQuery])

    function getTeacherList() {
        const _query: any = {
            ...teacherQueryRef.current,
        };
        StoreService.getStoreUserBasicPage(_query).then((res) => {
            const { result = {} } = res;
            const { records = [], total = 0, hasNext } = result;
            const list = _query.current > 1 ? teacherList.concat(records) : records;
            setTeacherList(list);
            setHasNext(hasNext)
        });
    }

    // 滑动加载更多讲师列表
    function handleScrollTeacherList(e: any) {
        const container = e.target;
        const scrollToBottom = container && container.scrollHeight <= container.clientHeight + container.scrollTop;
        if (scrollToBottom && hasNext) {
            let _teacherQuery: any = { ...teacherQueryRef.current };
            _teacherQuery.current = _teacherQuery.current + 1;
            setTeacherQuery(_teacherQuery)

        }
    }

    return <div className="search-condition__item">
        <span className="search-name">创建人：</span>
        <Select
            placeholder="请选择创建人"
            className='search-input'
            showSearch
            allowClear
            onPopupScroll={handleScrollTeacherList}
            suffixIcon={<span className="icon iconfont" style={{ fontSize: '12px', color: '#BFBFBF' }}>&#xe835;</span>}
            value={props.val || null}
            onChange={(value) => {
                props.onChange(value)
            }}
            onSearch={(value) => {
                let _teacherQuery: any = { ...teacherQueryRef.current };
                _teacherQuery.nickName = value;
                setTeacherQuery(_teacherQuery)
            }}
            onClear={() => {
                props.onChange(null)
                setTeacherQuery({
                    roleCodes:props.roleCodes,
                    current:1,
                    size: 10
                })
             }}
        >
            {teacherList.map((item: any) => {
                return (
                    <Select.Option value={item.id} key={item.id}>{item.nickName}</Select.Option>
                );
            })}
        </Select>
    </div>
}