import User from '@/common/js/user';
import React from 'react';
import Header from './Header'
import Service from "@/common/js/service";
import './ErrorCollege.less';

export default class ErrorCollege extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      menuType: true,
    }
  }

  componentDidMount() {
    this.getStorePermission();
  }

  getStorePermission() {
    const params = {
      storeId: User.getStoreId(),
    };
    Service.Hades('public/customerHades/whetherStopStore', params).then((res) => {
      if (!res.result) {
        window.RCHistory.replace({
          pathname: '/home',
        })
      }
    });
  }
  
  handleMenuType() {
    this.setState({ menuType: !menuType });
  }

  render() {
    const { menuType } = this.state;
    return (
      <div className="error-college-page">
        <Header id="error" handleMenuType={this.handleMenuType} menuType={menuType} />
        <div className="error-college-box">
          <img src="https://image.xiaomaiketang.com/xm/MQRaYkbr6J.png" className="error-college-image" />
          <span className="error-college-tip">{User.getStoreName()}已停用</span>
        </div>
      </div>
    )
  }
}