/*
 * @Author: yuananting
 * @Date: 2021-07-28 11:25:58
 * @LastEditors: yuananting
 * @LastEditTime: 2021-07-28 15:41:00
 * @Description: 任务中心-培训任务
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useEffect, useState } from 'react'
import TrainFilter from './components/TrainFilter'
import TrainOpt from './components/TrainOpt'
import TrainList from './components/TrainList'
// import PlanList from './components/PlanList'
import PlanService from '@/domains/plan-domain/planService'
import User from '@/common/js/user'
function TrainTaskPage() {
  const [trainListData, setTrainListData] = useState([]) // 培训任务列表
  const [query, setQuery] = useState({
    current: 1,
    size: 10
  })
  const [totalCount, setTotalCount] = useState(0) // 总数

  useEffect(() => {
    handleFetchTrainList()
  }, [query])

  function handleFetchTrainList(_query) {
    const params = {
      ...query,
      ..._query,
      storeUserId: User.getStoreUserId()
    }
    //动态获取计划列表
    PlanService.getTrainingPlanPage(params).then((res) => {
      const {
        result: { records = [], total }
      } = res
      setTrainListData(records)
      setTotalCount(total)
    })
  }
  
  function queryChange(_query) {
    const params = {
      ...query,
      ..._query
    }
    setQuery(params)
  }

  return (
    <div className='page'>
      <div className='content-header'>培训任务</div>
      <div className='box'>
        <TrainFilter />
        <TrainOpt />
        <TrainList trainListData={trainListData}/>
        {/* <PlanList planListData={planListData} query={query} totalCount={totalCount} onChange={queryChange} /> */}
      </div>
    </div>
  )
}
export default TrainTaskPage