/*
 * @Author: wufan
 * @Date: 2020-11-27 16:21:49
 * @LastEditors: wufan
 * @LastEditTime: 2020-11-30 15:46:10
 * @Description: Description
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useState, useEffect } from "react";
import { Modal, Form, Button, Input, Radio, Row, Col, message } from "antd";
import _ from "underscore";
import "./EmployeeAddOrEditModal.less";
import baseImg from "@/common/images/xiaomai-IMG.png";
import { CropperModal } from "@/components/";
import UpLoad from "../common/UpLoad";
import $ from 'jquery';
const RadioGroup = Radio.Group;
declare let window: any;

interface AddEmployeeModalProps {
  isOpen: boolean;
  choosedItem: {
    name?: string;
    phone?: string;
    role?: string;
    avatar?: string;
  };
  onClose: (e: any) => void;
}

function AddEmployeeModal(props: AddEmployeeModalProps) {
  const [name, setName] = useState("");
  const [phone, setPhone] = useState("");
  const [role, setRole] = useState('1');
  const [avatar, setAvatar] = useState(baseImg);
  const [imgUrl, setImgUrl] = useState(avatar);
  const [nameErrorMsg, setNameErrorMsg] = useState("");
  const [nameStatus, setNameStatus] = useState("");
  const [phoneErrorMessage, setPhoneErrorMessage] = useState("");
  const [phoneStatus, setPhoneStatus] = useState("");
  const [cropperModalVisible, setCropperModalVisible] = useState(false);

  useEffect(() => {
    if (props.choosedItem.name) {
      console.log("props.choosedItem",props.choosedItem);
      setName(props.choosedItem.name);
      props.choosedItem.phone && setPhone(props.choosedItem.phone);
      props.choosedItem.role && setRole(props.choosedItem.role);
      props.choosedItem.avatar && setAvatar(avatar || baseImg);
    }
  }, [props.choosedItem]);

  const layout = {
    labelCol: { span: 5 },
    wrapperCol: { span: 12 },
  };

  const onFinish = (values: any) => {
    console.log("Success:", values);
  };

  const onFinishFailed = (errorInfo: any) => {
    console.log("Failed:", errorInfo);
  };

  function handleChangeRole(value: string) {
    setRole(value);
  }

  function _handleUpdateAvatar(e: any): any {
    const avatar = e.target.files[0];
    const newUrl = URL.createObjectURL(avatar);
    const $image = $("#image");
    setImgUrl(newUrl);
    setCropperModalVisible(true);
  }

  function _onUpload(): any {
    $("#CrpperAvatarPic").trigger("click");
  }

  function changeAvatar(img: string): any {
    setAvatar(img);
    setImgUrl(img);
  }

  function closeCropperModal(): any {
    setCropperModalVisible(false);
  }

  function handleOk(): void {
      if(!name.trim()){
        setNameErrorMsg("请输入讲师姓名");
        setNameStatus("error");
        return;
      }
      if(!phone.trim()){
        setPhoneErrorMessage("请输入手机号码");
        setNameStatus("error");
        return;
      }
      if(phone.trim().length !== 11){
        setPhoneErrorMessage("请输入11位手机号");
        setNameStatus("error");
        return;
      }

  }
    console.log("role",name,phone,role);
    const [form] = Form.useForm();

  return (
    <Modal
      visible={props.isOpen}
      title={`${props.choosedItem.name ? "编辑员工" : "添加员工"}`}
      className="employee-add-modal"
      width={680}
      onCancel={props.onClose}
      onOk={handleOk}
    >
      <Row>
        <Col span={16}>
          <Form
            {...layout}
            form={form}
            name="basic"
            initialValues={{ name:"是电放费", phone: phone, role: role }}
            onFinish={onFinish}
            onFinishFailed={onFinishFailed}
          >
            <Form.Item
              label="员工姓名"
              name="name"
              rules={[{ required: true}]}
              // validateStatus={nameStatus}
              help={nameErrorMsg}
            >
              <Input
                style={{ width: 200 }}
                // value={name}
                placeholder="请输入员工名称"
                maxLength={15}
              />
            </Form.Item>

            <Form.Item
              label="手机号码"
              name="phone"
              rules={[{ required: true }]}
              // validateStatus={phoneStatus}
              help={phoneErrorMessage}
            >
              <Input
                style={{ width: 200 }}
                // value={phone}
                placeholder="请输入手机号"
                maxLength={11}
                disabled={!!props.choosedItem.name}
              />
            </Form.Item>

            <Form.Item
              label="员工身份"
              name="role"
              rules={[{ required: false }]}
            >
              <RadioGroup
                // value={role}
                onChange={(e) => {
                  handleChangeRole(e.target.value);
                }}
              >
                <Radio value={"1"}>
                  <span style={{ color: "#333" }}>普通讲师</span>
                  <p className="radio-tip">
                    仅可查看/使用与自己相关的文件和课表，并进行上课
                  </p>
                </Radio>
                <Radio value={"0"}>
                  <span style={{ color: "#333" }}>管理员</span>
                  <p className="radio-tip">可执行店铺中所有的操作</p>
                </Radio>
              </RadioGroup>
            </Form.Item>
          </Form>
        </Col>

        <Col span={8}>
          <div className="avatar-box">
            <div className="avatar-text">头像</div>
            <div className="avatart-img">
              <img className="avatar" src={avatar}></img>
            </div>
            <div className="upload-avatar">
              <Button id="click_upload_btn" onClick={_onUpload}>
                点击上传
              </Button>
              <input
                type="file"
                accept="image/*"
                id="CrpperAvatarPic"
                style={{ display: "none" }}
                onChange={_handleUpdateAvatar}
              />
              {cropperModalVisible && (
                <CropperModal
                  imgUrl={imgUrl}
                  save={changeAvatar}
                  close={closeCropperModal}
                />
              )}
            </div>
          </div>
        </Col>
      </Row>
    </Modal>
  );
}

export default AddEmployeeModal;
