/*
 * @Author: wufan
 * @Date: 2020-07-09 14:03:09
 * @Last Modified by: mikey.zhaopeng
 * @Last Modified time: 2020-11-28 13:53:12
 * 店铺管理-员工管理
 */
import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import _ from "underscore";
import PageControl from "@/components/PageControl";
import { CheckBox } from "@/components";
import { Button, Table, Tooltip, Modal, message, Row, Col, Input } from "antd";
import { QuestionCircleOutlined } from '@ant-design/icons';
import { storeRoleEnum } from "@/domains/store-domain/constants";
import StoreService from "@/domains/store-domain/storeService";
import EmployeeAddOrEditModal from './EmployeeAddOrEditModal';

import "./EmployeesManagePage.less";
const { confirm } = Modal;
const { Search } = Input;

declare var window: any;
interface RecordTypes {
 storeUserId: string,
 role: string
}

function EmployeesManagePage() {
  const [employeeList, setEmployeeList] = useState([
    {
      name: "赵云",
      phone: "18767118672",
      role: "0",
      storeUserId: "0"
    },
    {
        name: "吕布",
        phone: "18767118672",
        role: "0",
        storeUserId: "2"
      }
  ]);
  const [query, setQuery] = useState({
    current: 0,
    size: 10,
    name: "",
    phone: "",
    identity: "ALL",
    instId: "1837447" || window.currentUserInstInfo.instId,
  });
  const [total, setTotal] = useState(0);
  const [model, setModel] = useState(null);
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [isManager, setIsManager] = useState(true);
  const [isNormal, setIsNormal] = useState(true);
  const [choosedItem, setChooseItem] = useState({});

  useEffect(() => {
    // getEmployeeList();
  }, [query]);

  function getEmployeeList() {
    let _query = _.clone(query);
    _query.current = query.current + 1;
    StoreService.getEmployeeList(_query).then((res: any) => {
      console.log(res.result.records);
      setEmployeeList(res.result.records);
      setTotal(res.result.total);
    });
  }

  function parseColumn() {
    return [
      {
        title: "员工",
        dataIndex: "name",
        render: (val: string) => {
          return (
            <div className="coupon-info">
              <span className="title">{val}</span>
            </div>
          );
        },
      },
      {
        title: "手机号",
        dataIndex: "phone",
        key: "phone",
        render: (val: string) => {
          return <div>{val}</div>;
        },
      },
      {
        title: "身份",
        dataIndex: "role",
        key: "role",
        render: (val: string, record: RecordTypes) => {
          return <div>{/* {storeRoleEnum[val]} */}</div>;
        },
      },
      {
        title: "操作",
        dataIndex: "operation",
        render: (val: string, record: RecordTypes) => {
          return record.role === "" || record.role === "1" ? (
            <div className="no-operate">-</div>
          ) : (
            <div className="operation">
              <span
                className="edit"
                onClick={() => handleEditEmployee(record)}
              >
                编辑
              </span>
              <span className="divider-line">{" | "}</span>
              <span
                className="delete"
                onClick={() => handleDeleteEmployeeConfirm(record)}
              >
                删除
              </span>
            </div>
          );
        },
      },
    ];
  }

  function handleEditEmployee(record: object) {
    setChooseItem(record);
    setIsModalOpen(true);
  }

  function handleDeleteEmployeeConfirm(record: RecordTypes) {
    return  confirm({
      title: '你确定要删除此讲师吗？',
      content: '删除后，讲师将不能登录系统，此操作不能被撤销',
      icon: <QuestionCircleOutlined />,
      okText: '删除',
      okType: 'danger',
      cancelText: '取消',
      onOk: () => {
        handleDeleteEmployee(record.storeUserId);
      }
    })
  }


  function handleToAddEmployee() {
    setIsModalOpen(true);
  }

  function handleDeleteEmployee(storeUserId: string) {
    StoreService.deleteEmployee(storeUserId).then((res: any) =>{
      message.success("讲师已删除");
    });
  }

  function handleQuery(name: string, value: any) {
    const _query = _.clone(query);
    // _query[name] = value;
    setQuery(_query);
  }

  return (
    <div className=" page employee-manage-page">
      <div className="page-content">
        <div className="content-header">员工管理</div>
        <div className="box">
          <div className="box-header">
            <div
              style={{
                display: "flex",
                alignItems: "center",
                justifyContent: "space-between",
                padding: "15px 0 10px",
              }}
            >
              <div style={{ flex: 1 }}>
                搜索员工：
                <Search
                  style={{
                    width: 300,
                    marginRight: 40,
                  }}
                  placeholder="搜索员工姓名/手机号"
                  onChange={(event) => {
                    const val = event.target.value;
                    const _query = { ...query };
                    _query.name = val;
                    setQuery(_query);
                  }}
                  onSearch={() => getEmployeeList()}
                />
                {/* <Search placeholder="input search text"  style={{ width: 200 }} /> */}
              </div>

              <div style={{ flex: 1 }}>
                身份：
                <CheckBox
                  text="普通讲师"
                  onChange={(e: any) => {
                    const { checked } = e.target;
                    setIsNormal(checked);
                    const _query = { ...query };
                    _query.identity = checked
                      ? isManager
                        ? "ALL"
                        : "NORMAL"
                      : isManager
                      ? "MANAGE"
                      : "NONE";
                    setQuery(_query);
                  }}
                  defaultChecked={isNormal}
                />
                <CheckBox
                  text="管理员"
                  onChange={(e: any) => {
                    const { checked } = e.target;
                    setIsManager(checked);
                    const _query = { ...query };
                    _query.identity = checked
                      ? isNormal
                        ? "ALL"
                        : "MANAGE"
                      : isNormal
                      ? "NORMAL"
                      : "NONE";
                    setQuery(_query);
                  }}
                  defaultChecked={isManager}
                />
              </div>
            </div>
            <Button
              onClick={() => {
                handleToAddEmployee();
              }}
              type="primary"
              className="add-show-btn"
            >
              添加员工
            </Button>
          </div>
          <div className="box-body">
            <Table
              size={"middle"}
              pagination={false}
              dataSource={employeeList}
              columns={parseColumn()}
              rowKey={(item: any) => item.id}
              bordered
            />
          </div>
          <div className="box-footer">
            <PageControl
              current={query.current}
              pageSize={query.size}
              total={total}
              toPage={(page) => {
                const queryStates = _.clone(query);
                queryStates.current = page;
                setQuery(queryStates);
              }}
            />
          </div>
        </div>
        {
            isModalOpen && <EmployeeAddOrEditModal  isOpen={isModalOpen} choosedItem={choosedItem} onClose={()=>{setIsModalOpen(false)}}/>
        }
        {model}
      </div>
    </div>
  );
}

export default withRouter(EmployeesManagePage);
