/*
 * @Author: wufan
 * @Date: 2020-11-27 16:21:49
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-12-07 19:51:03
 * @Description: Description
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useState, useEffect } from "react";
import { Modal,Form,Input,Button,Select} from "antd";
import './SecondCatalogAddOrEditModal.less'
import User from '@/common/js/user';
import StoreService from "@/domains/store-domain/storeService";


const { Option } = Select;
interface SecondCatalogAddOrEditModalProps {
  onClose:any;
  modalType:string;
  parentId:string;
  choosedItem:any;
  refreshCatalogList:any;
}

function SecondCatalogAddOrEditModal(props: SecondCatalogAddOrEditModalProps) {
  const {onClose,modalType,parentId,refreshCatalogList} = props;
  const [secondCatalogName,setSecondCatalogName] =  useState('');
  useEffect(() => {

  });

  function handleConfirm(){
    if(modalType === "add"){
      addSecondcatalog();
    }
  }
  function addSecondcatalog():any{
    const param = {
      parentId,
      storeId: User.getStoreId(),
      categoryName:secondCatalogName
    }
    StoreService.addCourseCategory(param).then((res: any) => {
      const data = {
        type:'addSecondCatalog',
        catalogName:secondCatalogName,
        parentId,
        id:res.result
      }
      refreshCatalogList(data);
      onClose();
    });
  }
  return (
    <Modal
      visible={true}
      title={modalType === "add" ? '添加子分类' : '编辑子分类' }
      className="second-catalog-add-edit-modal"
      onCancel={onClose}
      width={448}
      footer={[
        <Button
            id='cancel_allot_btn'
            key="back" onClick={onClose}>取消</Button>,
        <Button
            id='confirm_allot_btn'
            key="submit"
            type="primary"
            onClick={() => {
                handleConfirm()
            }}>
            保存
        </Button>
      ]}
    >
     <Form
        labelCol={ {span:6 }}
     >
        <Form.Item
              label="子分类名称"
              name="子分类名称"
              rules={[{ required: true}]}
          >
          <Input type="text" 
              placeholder="请输入子分类名称，最多10个字"
              maxLength={10}  
              style={{ width: 240 }}  
              onChange={(e) => { 
                setSecondCatalogName(e.target.value);
              }}  
          />  
        </Form.Item>
        <Form.Item
              label="所属分类"
              name="所属分类"
              rules={[{ required: true}]}
          >
          <Select style={{ width: 240 }}>
            <Option value="china">全部</Option>
            <Option value="usa">一阶培训</Option>
        </Select>
        </Form.Item>
     </Form>
    </Modal>
  );
}

export default SecondCatalogAddOrEditModal;
