import React, { useEffect, useState } from 'react'
import { TreeSelect } from 'antd'
import User from '@/common/js/user'
import Service from '@/common/js/service'
function CourseCatalogSelect(props) {
  let {
    showSearch = true,
    value = '',
    treeNodeFilterProp = 'title',
    style = { width: 240 },
    dropdownStyle = { maxHeight: 300, overflow: 'auto' },
    placeholder = '请选择课程类型',
    allowClear = true,
    onChange = () => {},
  } = props
  let [courseCatalogList, setCourseCatalogList] = useState([])
  useEffect(() => {
    //获取分类列表
    function getCourseCatalogList() {
      Service.Hades('public/hades/queryCategoryTree', { source: 0, tenantId: User.getStoreId(), count: false, userId: User.getUserId() }).then((res) => {
        const { categoryList = [] } = res.result
        let list = renderTreeNodes(categoryList)
        setCourseCatalogList(list)
      })
    }
    function renderTreeNodes(list) {
      let newTreeData = list.map((item) => {
        item.title = item.categoryName
        item.value = item.id
        item.key = item.id
        console.log(value, item.value, value === item.value, 'item.categoryName')

        if (item.sonCategoryList) {
          item.children = renderTreeNodes(item.sonCategoryList)
        }
        return item
      })
      return newTreeData
    }
    getCourseCatalogList()
  }, [])

  return (
    <TreeSelect
      treeNodeLabelProp='categoryName'
      showSearch={showSearch}
      treeNodeFilterProp={treeNodeFilterProp}
      style={style}
      value={value}
      dropdownStyle={dropdownStyle}
      treeData={courseCatalogList}
      placeholder={placeholder}
      allowClear={allowClear}
      treeDefaultExpandAll
      onChange={(value, label) => {
        onChange(value, label)
      }}
    />
  )
}
export default CourseCatalogSelect
