import React, { useEffect, useState } from 'react';
import { withRouter } from "react-router-dom";
import { Row, Input, Select, Tooltip, Col } from 'antd';
import RangePicker from '@/modules/common/DateRangePicker';
import { PageControl, XMTable } from '@/components';
import ENUM from '../../emun';
import moment from 'moment';
const { Search } = Input;
const { Option } = Select;
declare var formatDate: any;

function StudyTable(props: any) {
    const [query, setQuery] = useState<any>({ current: 1, size: 10 });
    const [list,setList] = useState<any[]>([]);
    const [total,setTotal] = useState<any>(0);

    const columns = [
        {
            title: '学员',
            key: 'storeCustomerName',
            dataIndex: 'storeCustomerName',
            render: (val: any, record: any) => {
                return <div>{val}</div>;
            },
        },
        {
            title: '部门',
            key: 'learnState2',
            dataIndex: 'learnState2',

        },
        {
            title: '岗位',
            key: 'learnState1',
            dataIndex: 'learnState1',

        },
        {
            title: '学习状态',
            key: 'learnState',
            dataIndex: 'learnState',
            render: (val: any, record: any) => {

                return <div>{ENUM.LearnState[val].text}</div>;
            },
        },
        {
            title: '学习进度',
            key: 'learnState',
            dataIndex: 'learnState',
            render: (val: any, record: any) => {

                return <div>{ENUM.LearnState[val].text}</div>;
            },
        },
        
        {
            title: '最近学习时间',
            key: 'latelyLearnTime',
            dataIndex: 'latelyLearnTime',
            sorter: true,
            width: 240,
            render: (val: any, record: any) => {

                return `${formatDate('YYYY-MM-DD H:i', parseInt(record.latelyLearnTime))}`;
            },
        },
        {
            title: '开始学习时间',
            key: 'startLearnTime',
            dataIndex: 'startLearnTime',
            width: 240,
            sorter: true,
            render: (val: any, record: any) => {
                return <div>{formatDate('YYYY-MM-DD H:i', val)}</div>;
            },
        },

        {
            title: '操作',
            key: 'operate',
            dataIndex: 'operate',
            render: (val: any, record: any) => {
                return (
                    <div className='operate-area'>
                        <span className='operate-item' onClick={() => { }}>
                            查看数据
                        </span>

                    </div>
                );
            },
        },
    ];


    return <div className="study_Table">
        <div className="filter">
            <Row>
                <Col span={7}>
                    <div className='xm_search_item'>
                        <span className='label'>学员：</span>
                        <div className="search">
                            <Search
                                value={query.customerName}
                                placeholder='搜索学员名称'
                                onChange={(e) => {

                                }}
                                onSearch={() => {

                                }}
                                enterButton={<span className='icon iconfont'>&#xe832;</span>}
                            />
                        </div>

                    </div>
                </Col>
                <Col span={7}>
                    <div className='xm_search_item'>
                        <span className='label '>学习状态：</span>
                        <div className="search">
                            <Select
                                style={{ width: '100%' }}
                                placeholder='请选择当前状态'
                                allowClear={true}
                                value={query.learnState}
                                onChange={(value) => {

                                }}
                                suffixIcon={
                                    <span className='icon iconfont' style={{ fontSize: '12px', color: '#BFBFBF' }}>
                                        &#xe835;
                                    </span>
                                }>
                                <Option value='UN_PLAY'>未开始</Option>
                                <Option value='UNDER_WAY'>进行中</Option>
                                <Option value='FINISH'>已完成</Option>
                            </Select>
                        </div>

                    </div>
                </Col>
                <Col span={7}>
                    <div className='xm_search_item'>
                        <span className='label'>最近学习日期：</span>
                        <div className="search">
                            <RangePicker
                                style={{ width: '100%' }}
                                id='course_date_picker'
                                allowClear={false}
                                value={query.startTime ? [moment(query.startTime), moment(query.endTime)] : null}
                                format={'YYYY-MM-DD'}
                                onChange={(dates: any) => {

                                }}

                            />
                        </div>

                    </div>
                </Col>
                <Col offset={2} span={1} >
                    <Tooltip title='清空筛选'>
                        <span className='resetBtn iconfont icon' onClick={() => { }}>
                            &#xe61b;{' '}
                        </span>
                    </Tooltip>
                </Col>
            </Row>

        </div>
        <div style={{marginTop:12}}>
          <XMTable
            renderEmpty={{
              type: 'college',
              description: '暂无数据',
            }}
            rowKey={(record:any) => record.storeCustomerId}
            dataSource={list}
            columns={columns}
            pagination={false}
            className='user-learning-table'
            onChange={()=>{}}
            showSorterTooltip={false}
            bordered
          />
          {list.length > 0 && (
            <div className='box-footer'>
              <PageControl
                current={query.current - 1}
                pageSize={query.size}
                total={total}
                toPage={(page:any) => {
               
                }}
              
              />
            </div>
          )}
        </div>

    </div>
}

export default withRouter(StudyTable)