/*
 * @Author: yuananting
 * @Date: 2021-07-29 13:57:03
 * @LastEditors: yuananting
 * @LastEditTime: 2021-08-02 17:25:17
 * @Description: 任务中心-培训任务-新建页面
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useEffect, useState } from 'react';
import { Button, Tabs, message, Modal, Space } from 'antd';
import ShowTips from '@/components/ShowTips';
import Breadcrumbs from '@/components/Breadcrumbs';
import BasicInfo from './components/BasicInfo';
import TrainContent from './components/TrainContent';
// import ExpiredCourseList from './components/ExpiredCourseList';
import PlanService from '@/domains/plan-domain/planService';
import User from '@/common/js/user';
import _ from 'underscore';
import './AddTrainTask.less';
import Bus from '@/core/bus';
const { TabPane } = Tabs;

const defaultCover = 'https://image.xiaomaiketang.com/xm/rEAetaTEh3.png';

const DEFAULT_BASIC_INFO = {
  planName: '',
  coverUrl: defaultCover,
  coverId: null,
  durationType: 'NEVER_EXPIRES',
  learnType: 'FREEDOM',
  enableState: 'YES',
  selectOperatorList: [],
  instro: '',
  operateType: 'All_Operate',
  percentCompleteLive: 80,
  percentCompleteVideo: 80,
  percentCompletePicture: 100,
};

const DEFAULT_TASK_LIST = [
  {
    taskName: '阶段一',
    courseList: [],
  },
];

function AddTrainTask() {
  const type = getParameterByName('type');
  const [activeStep, setActiveStep] = useState('BASIC_INFO');
  const [basicInfo, setBasicInfo] = useState(DEFAULT_BASIC_INFO);
  const [taskList, setTaskList] = useState(DEFAULT_TASK_LIST);

  function renderFooter() {
    return (
      <Choose>
        <When condition={activeStep === 'BASIC_INFO'}>
          <div className='footer shrink-footer'>
            <Button onClick={handleGoBack}>取消</Button>
            <Button onClick={() => console.log('提交')}>保存</Button>
            <Button type='primary' onClick={() => console.log('下一步')}>
              下一步
            </Button>
            {/* disabled={submitDisabled} */}
          </div>
        </When>
        <Otherwise>
          <div className='footer shrink-footer'>
            <Button onClick={handleGoBack}>取消</Button>
            <Button onClick={() => console.log('上一步')}>上一步</Button>
            <Button onClick={() => console.log('提交')}>保存</Button>
            <Button type='primary' onClick={() => console.log('提交')}>
              保存并发布
            </Button>
            {/* disabled={submitDisabled} */}
          </div>
        </Otherwise>
      </Choose>
    );
  }

  function handleGoBack() {
    window.RCHistory.goBack();
  }

  function handleChangeBasicInfo(field, value) {
    setBasicInfo({
      ...basicInfo,
      [field]: value,
    });
  }

  function handleChangeTaskInfo(value) {
    setTaskList(value);
  }

  return (
    <div className='page add-train-task'>
      <Breadcrumbs navList={type == 'add' ? '新建培训任务' : '编辑培训任务'} goBack={handleGoBack} />
      <div className='box'>
        <div className='show-tips'>
          <ShowTips message='请遵守国家相关规定，切勿上传低俗色情、暴力恐怖、谣言诈骗、侵权盗版等相关内容，小麦企学院保有依据国家规定及平台规则进行处理的权利' />
        </div>
        <div className='header-tab'>
          <span className='tab-title' onClick={() => setActiveStep('BASIC_INFO')}>
            <span className={`step-icon ${activeStep === 'BASIC_INFO' ? 'active-icon' : 'default-icon'}`}>1</span>
            <span style={{ position: 'relative' }}>
              <span className={`${activeStep === 'BASIC_INFO' && 'active-text'}`}>基本信息</span>
              {activeStep === 'BASIC_INFO' && <span className='active-line'></span>}
            </span>
          </span>
          <span className='next-arrow'></span>
          <span className='tab-title' onClick={() => setActiveStep('TRAIN_CONTENT')}>
            <span className={`step-icon ${activeStep === 'TRAIN_CONTENT' ? 'active-icon' : 'default-icon'}`}>2</span>
            <span style={{ position: 'relative' }}>
              <span className={`${activeStep === 'TRAIN_CONTENT' && 'active-text'}`}>培训内容</span>
              {activeStep === 'TRAIN_CONTENT' && <span className='active-line'></span>}
            </span>
          </span>
        </div>
        {activeStep === 'BASIC_INFO' && <BasicInfo data={basicInfo} onChange={handleChangeBasicInfo} />}
        {activeStep === 'TRAIN_CONTENT' && <TrainContent data={taskList} onChange={handleChangeTaskInfo} />}
      </div>
      {renderFooter()}
    </div>
  );
}

export default AddTrainTask;
