/*
 * @Author: yuananting
 * @Date: 2021-08-03 10:47:59
 * @LastEditors: yuananting
 * @LastEditTime: 2021-08-03 14:08:56
 * @Description: 编辑培训任务-失效课程
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from 'react';
import { List } from 'antd';
import './ExpiredCourseList.less';
import { LearningContentIcon } from '@/common/constants/academic/taskEnum';

function ExpiredCourseList(props) {
  const expiredCourseList = [1, 2, 3, 4];
  return (
    <div className='expired-list-page'>
      <div className='tip'>为了不影响学员学习，「未成功开课」的课程已从任务中移出，具体课程如下所示：</div>
      <List
        dataSource={expiredCourseList}
        renderItem={(item) => (
          <List.Item>
            <div className='item-detail'>
              <span className='icon iconfont'>&#xe80b;</span>
              <span className='content-status'>未成功开课</span>
              <span className='stage-name'>阶段一、</span>
              <span className='content-name'>
                <img src={LearningContentIcon['LIVE']} />
                <span>2.1 入门培训任务</span>
              </span>
              <span className='teacher-name'>张老师</span>
              <span className='split'>|</span>
              <span className='course-time'>2020-12-12 09:00~10:00</span>
              <span className='del-btn'>删除记录</span>
            </div>
          </List.Item>
        )}
      />
    </div>
  );
}

export default ExpiredCourseList;
