/*
 * @Author: yuananting
 * @Date: 2021-03-27 16:15:13
 * @LastEditors: yuananting
 * @LastEditTime: 2021-03-30 19:38:00
 * @Description: 助学工具-新建试卷
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { Component } from "react";
import {
  Form,
  Button,
  Input,
  Table,
  InputNumber,
  ConfigProvider,
  Empty,
  Tooltip,
} from "antd";
import { PlusOutlined } from "@ant-design/icons";
import ShowTips from "@/components/ShowTips";
import Breadcrumbs from "@/components/Breadcrumbs";
import "./NewExaminationPaper.less";
import SelectQuestionModal from "./modal/SelectQuestionModal";

const questionTypeEnum = {
  SINGLE_CHOICE: "单选题",
  MULTI_CHOICE: "多选题",
  JUDGE: "判断题",
  GAP_FILLING: "填空题",
  INDEFINITE_CHOICE: "不定项选择题",
};
class NewExaminationPaper extends Component {
  formRef = React.createRef();
  constructor(props) {
    super(props);
    this.state = {
      questionFormData: {
        examinationPaperName: null, // 试卷名称
        passScore: null, // 及格线
        questionList: [], // 题目列表
      },
      questionData: {
        totalScore: 0,
        totalCount: 0,
        singleCount: 0,
        singleScore: 0,
        multiCount: 0,
        multiScore: 0,
        judgeCount: 0,
        judgeScore: 0,
        gapCount: 0,
        gapScore: 0,
        indefiniteCount: 0,
        indefiniteScore: 0,
      },
    };
  }

  // 自定义表格空状态
  customizeRenderEmpty = () => {
    return (
      <Empty
        image="https://image.xiaomaiketang.com/xm/emptyTable.png"
        imageStyle={{
          height: 100,
        }}
        description={"请在右上角选择出题方式添加题"}
      ></Empty>
    );
  };

  // 选择题目
  chooseQuestion = () => {
    const m = (
      <SelectQuestionModal
        setSelectedQuestion={(list) => {
          this.setState(
            {
              questionList: list,
              selectQuestionModal: null,
            },
            () => {
              console.log(this.state.questionList);
            }
          );
        }}
        close={() => {
          this.setState({
            selectQuestionModal: null,
          });
        }}
      />
    );
    this.setState({ selectQuestionModal: m });
  };

  // 保存题目
  saveExaminationPaper = async () => {
    try {
      await this.formRef.current.validateFields();
    } catch (e) {
      console.log(e);
    }
  };

  render() {
    const formItemLayout = {
      labelCol: { span: 2 },
      wrapperCol: { span: 10 },
    };

    const columns = [
      {
        title: "序号",
        dataIndex: "index",
        width: "10%",
        render: (val, record, index) => {
          return <span>{index + 1}</span>;
        },
      },
      {
        title: "题型",
        dataIndex: "questionTypeEnum",
        width: "16%",
        filters: [
          {
            text: "单选题",
            value: "SINGLE_CHOICE",
          },
          {
            text: "多选题",
            value: "MULTI_CHOICE",
          },
          {
            text: "判断题",
            value: "JUDGE",
          },
          {
            text: "填空题",
            value: "GAP_FILLING",
          },
          {
            text: "不定项选择题",
            value: "INDEFINITE_CHOICE",
          },
        ],
        filterMultiple: false,
        onFilter: (value, record) => record.questionTypeEnum.indexOf(value) === 0,
        render: (val) => questionTypeEnum[val]
      },
      {
        title: "题目",
        dataIndex: "questionStem",
        ellipsis: {
          showTitle: false,
        },
        render: (val) => {
          var handleVal = val;
          handleVal = handleVal.replace(/<(?!img|input).*?>/g, "");
          handleVal = handleVal.replace(/<\s?input[^>]*>/gi, "_、");
          handleVal = handleVal.replace(/\&nbsp\;/gi, " ");
          return (
            <Tooltip
              overlayClassName="aid-tool-list"
              title={
                <div style={{ maxWidth: 700, width: "auto" }}>{handleVal}</div>
              }
              placement="topLeft"
              overlayStyle={{ maxWidth: 700 }}
            >
              {handleVal}
            </Tooltip>
          );
        },
      },
      {
        title: "分值",
        dataIndex: "score",
        width: "12%",
        render: (val) => {
          return <InputNumber min={1} max={100} defaultValue={2} />;
        },
      },
      {
        dataIndex: "extraScore",
        width: "18%",
        render: (val) => {
          return (
            <div>
              漏选得
              <InputNumber defaultValue={0} />
            </div>
          );
        },
      },
      {
        title: "操作",
        dataIndex: "operate",
        width: "10%",
        render: (val, record) => <span>移除</span>,
      },
    ];
    const {
      selectQuestionModal,
      questionData,
      examinationPaperName,
      passScore = 60,
      questionList = [],
    } = this.state;

    const {
      totalScore = 0,
      totalCount = 0,
      singleCount = 0,
      singleScore = 0,
      multiCount = 0,
      multiScore = 0,
      judgeCount = 0,
      judgeScore = 0,
      gapCount = 0,
      gapScore = 0,
      indefiniteCount = 0,
      indefiniteScore = 0,
    } = questionData;

    return (
      <div className="page new-examination-paper">
        <Breadcrumbs navList={"新建试卷"} goBack={() => this.handleGoBack()} />
        <div className="box">
          <div className="show-tips">
            <ShowTips message="请遵守国家相关规定，切勿上传低俗色情、暴力恐怖、谣言诈骗、侵权盗版等相关内容，小麦企培保有依据国家规定及平台规则进行处理的权利" />
          </div>
          <Form
            ref={this.formRef}
            {...formItemLayout}
            style={{ width: 1020, marginTop: 32 }}
          >
            <h1 style={{ fontSize: 16 }}>基本信息</h1>
            <Form.Item
              name="examinationPaperName"
              label="试卷名称："
              required
              rules={[
                {
                  required: true,
                  message: "请输入试卷名称",
                },
              ]}
            >
              <Input
                value={examinationPaperName}
                autoComplete="off"
                maxLength={40}
                placeholder="请输入试卷名称（40字以内）"
              />
            </Form.Item>
            <div
              style={{
                display: "flex",
                justifyContent: "space-between",
                marginTop: 32,
              }}
            >
              <h1 style={{ fontSize: 16 }}>题目管理</h1>
              <Button icon={<PlusOutlined />} onClick={this.chooseQuestion}>
                自选题目
              </Button>
            </div>
            <div style={{ margin: "10px 0 20px" }}>
              总计{totalScore}分，共{totalCount}题。 单选题{singleCount}题，共
              {singleScore}分；多选题{multiCount}题，共{multiScore}分；判断题
              {judgeCount}题，共{judgeScore}分，填空题{gapCount}题，共{gapScore}
              分，不定项选择题{indefiniteCount}题，共{indefiniteScore}分
            </div>
            <Form.Item label="及格线：" required>
              <div>
                <Form.Item
                  noStyle
                  initialValue={60}
                  name="passScore"
                  rules={[
                    ({ getFieldValue }) => ({
                      validator(_, value) {
                        if (!value) {
                          return Promise.reject("请输入及格线");
                        } else {
                          return Promise.resolve();
                        }
                      },
                    }),
                  ]}
                >
                  <InputNumber
                    min={1}
                    max={100}
                    value={passScore}
                    onChange={(value) => {
                      this.setState({
                        passScore: value,
                      });
                    }}
                  />
                </Form.Item>{" "}
                %
                <span style={{ marginLeft: 20 }}>
                  总分（0）*及格线（{passScore || 0}%）=及格分数（0）
                </span>
              </div>
            </Form.Item>
            <ConfigProvider renderEmpty={this.customizeRenderEmpty}>
              <Table
                columns={columns}
                dataSource={questionList}
                pagination={false}
              />
            </ConfigProvider>
          </Form>
        </div>
        <div className="footer">
          <Button>取消</Button>
          <Button>预览</Button>
          <Button type="primary" onClick={this.saveExaminationPaper}>
            保存
          </Button>
        </div>
        {selectQuestionModal}
      </div>
    );
  }
}

export default NewExaminationPaper;
