/*
 * @Author: yuananting
 * @Date: 2021-03-29 10:52:26
 * @LastEditors: yuananting
 * @LastEditTime: 2021-03-30 19:17:30
 * @Description: 助学工具-新建试卷-选择题目弹窗
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { Component } from "react";
import { Modal } from "antd";
import CourseCategorySiderTree from "../../components/CourseCategorySiderTree";
import SelectQuestionContent from "../components/SelectQuestionContent";
import "./SelectQuestionModal.less";

class SelectQuestionModal extends Component {
  listRef = React.createRef();
  constructor(props) {
    super(props);
    this.state = {
      selectedCategoryId: null,
    };
  }

  getCategoryIdFromSider = (selectedCategoryId) => {
    if (selectedCategoryId && selectedCategoryId.length > 0) {
      this.setState({ selectedCategoryId: selectedCategoryId[0] });
    }
  };

  render() {
    return (
      <Modal
        destroyOnClose={true}
        title="选择题目"
        visible={true}
        width={1200}
        onOk={() =>
          this.props.setSelectedQuestion(
            this.listRef.current.state.selectQuestionKeys
          )
        }
        onCancel={this.props.close}
        className="select-question-modal"
      >
        <div className="box content-body">
          <div
            style={{ borderRight: "0.5px solid #EEEEEE", paddingRight: "4px" }}
          >
            <div className="sider">
              <CourseCategorySiderTree
                fromModule="modal"
                getSelectedCategoryId={this.getCategoryIdFromSider.bind(this)}
              />
            </div>
          </div>
          <div className="content">
            <SelectQuestionContent
              fromModule="modal"
              ref={this.listRef}
              selectedCategoryId={this.state.selectedCategoryId}
            />
          </div>
        </div>
      </Modal>
    );
  }
}

export default SelectQuestionModal;
