/*
 * @Author: 陈剑宇
 * @Date: 2020-05-14 10:29:52
 * @LastEditTime: 2021-03-02 10:11:25
 * @LastEditors: yuananting
 * @Description: 上传文件进度
 * @FilePath: /xiaomai-web-b/app/modules/newAcademic_V5/punchClock/components/UploadingProgress.jsx
 * @Copyright © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { Component } from "react";
import { Tooltip } from 'antd';
import {
  FileVerifyMap,
} from "@/common/constants/academic/lessonEnum";

import './UploadingProgress.less';

const FILE_ICON = {
  WORD: 'https://image.xiaomaiketang.com/xm/5CCFBWrRMB.png',
  PPT: 'https://image.xiaomaiketang.com/xm/3ypFCHEj3c.png',
  EXCEL: 'https://image.xiaomaiketang.com/xm/AijpZjphPn.png',
  PDF: 'https://image.xiaomaiketang.com/xm/3kZapsD3Pc.png',
  VIDEO: 'https://image.xiaomaiketang.com/xm/rYCcpGaMW3.png',
  VOICE: 'https://image.xiaomaiketang.com/xm/XT8eGhNhpb.png',
  PICTURE: 'https://image.xiaomaiketang.com/xm/TXt5RHbFfF.png',
  FAIL: 'https://image.xiaomaiketang.com/xm/EzmdwZz6mH.png'
}

const UPLOAD_FAIL = {
  url: 'https://image.xiaomaiketang.com/xm/k8bynH452k.png',
  title: '上传失败',
}

const UPLOAD_INIT = {
  url: 'https://image.xiaomaiketang.com/xm/JbRFwhAaQ8.png',
  title: '正在上传'
}

class UploadingProgress extends Component {
  // 获取文件类型
  getFileType(item) {
    let fileEnum = 'FAIL';
    if (FILE_ICON[item.contentType]) {
      fileEnum = item.contentType;
    } else if (FileVerifyMap[item.fileType] && FileVerifyMap[item.fileType].type) {
      fileEnum = FileVerifyMap[item.fileType].type.toUpperCase()
    }
    return fileEnum;
  }

  render() {
    const { fileDesc, fileDesc: { contentName, progress = 0, status = 'init' }, canCancelUpload, onAbort, onReupload } = this.props;
    const isFail = status === 'fail';
    const statusTips = isFail ? UPLOAD_FAIL : UPLOAD_INIT;
    let imgUrl = (isFail && !canCancelUpload) ? FILE_ICON.FAIL : FILE_ICON[this.getFileType(fileDesc)];
    return (
      <div className="uploading-progress-box">
        <div className="icon-box mr8">
          <img src={imgUrl} alt="" />
        </div>
        <div className="file-box">
          <div className="file-info">
            <div className="file-title">{contentName}</div>
            <div className="file-status">
              <img src={statusTips.url} alt="" />
              <span>{statusTips.title}</span>
            </div>
          </div>
          {(!isFail || canCancelUpload) && <div className="file-progress-box">
            <div className="file-progress" style={{ width: `${progress}%` }}></div>
          </div>}
        </div>
        {canCancelUpload && ['init', 'fail'].includes(status) &&
          <div className="file-extra-box">
            <Tooltip title="取消上传"><span className="icon iconfont" onClick={() => onAbort && onAbort()} style={{transform:"scale(.8)"}}>&#xe6ef;</span></Tooltip>
            {status === 'fail' && <Tooltip title='重新上传'><span className="icon iconfont" onClick={() => onReupload && onReupload()}>&#xe75a;</span></Tooltip>}
          </div>
        }
      </div>
    )
  }
}

export default UploadingProgress;