import React, { useContext, useEffect, useState, version } from "react";
import "./HomeTip.less"
import { VersionContext } from "@/store/context";
import ContactWidget from '@/components/ContactWidget';
import { Carousel } from "antd";
import moment from "moment";

export default function HomeTip() {

    const [isOverNum, setIsOverNum] = useState<boolean>(false)
    const [tipType, setTipType] = useState(0) //0不显示1即将过期2已过期
    const [expirationTime, setExpirationTime] = useState("")
    const [surplusDay, setSurplusDay] = useState(0)
    const versionInfo = useContext(VersionContext)
  
    useEffect(()=> {
      if (versionInfo) {
        setIsOverNum(versionInfo.userNum === -1 ? false : versionInfo.whetherReachUserNum)
        setSurplusDay(versionInfo.surplusDayTime)
        setExpirationTime(versionInfo.validEndTime)
        if (versionInfo.stateEnum === "NO") {
            setTipType(2)
          } else if (versionInfo.surplusDayTime === 30 || versionInfo.surplusDayTime <= 7) {
            setTipType(1)
          }
      }
      
    },[versionInfo])
  
    return (
      <div className="home-tip">
        {
          (isOverNum || tipType !== 0) &&
        <div className="tip">
          <Carousel dotPosition="left" dots={false} autoplay={true} autoplaySpeed={5000}>
            {
              isOverNum && (
                <div className="content">
                  <span className="icon iconfont" style={{color:"#FF4F4F",marginRight:"8px"}}>&#xe61d;</span>温馨提示：企业使用人数已达上限，将无法新增员工、学员，如需增加人数限制，请联系小麦企学院服务平台。
                  <ContactWidget placement="bottom" trigger="hover"><div className="renew-btn">立即续费</div></ContactWidget> 
                </div>
              )
            }
            {
              tipType === 2 && (
                <div className="content">
                  <span className="icon iconfont" style={{color:"#FF4F4F",marginRight:"8px"}}>&#xe61d;</span>版本到期提醒：当前企业购买的小麦企学院服务已于{moment(versionInfo?.validEndTimeST).format("YYYY-MM-DD HH:mm:ss")}到期，到期后仍可访问，但功能不可使用，建议尽快续费购买哦~
                  <ContactWidget placement="bottom" trigger="hover"><div className="renew-btn">立即续费</div></ContactWidget> 
                </div>
              )
            }
            {
              tipType === 1 && (
                <div className="content">
                  <span className="icon iconfont" style={{color:"#FF4F4F",marginRight:"8px"}}>&#xe61d;</span>当前企业购买的小麦企学院服务仅剩{surplusDay}天（于{expirationTime}到期），为了不影响使用，建议尽快续费购买哦~
                  <ContactWidget placement="bottom" trigger="hover"><div className="renew-btn">立即续费</div></ContactWidget> 
                </div>
              )
            }
          </Carousel>
        </div>
        }
    </div>
    )
  }