/*
 * @Author: zhujian 
 * @Date: 2017-09-07 14:04:50 
 * @Last Modified by: mikey.zhaopeng
 * @Last Modified time: 2020-03-23 17:11:29
 */
import React from "react";
import PropTypes from 'prop-types';
import { Button, Icon, Upload, Avatar } from 'antd';
import './Upload.less';
import {CropperModal} from '@/components/';

const baseImg = require('@/common/images/xiaomai-IMG.png');
class UpLoad extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      img: this.props.img || '',
    }
  }

  componentWillReceiveProps(nextProps) {
    const img = nextProps.img;
    this.setState({ img })
  }

  //上传头像
  handleUpdateAvatar = () => {
    const self = this
    this.cropperModal = <CropperModal 
      imgUrl={self.state.img}
      save={self.changeAvatar}
      close={self.closeCropperModal}
      type={self.props.tag}
    />
    this.setState({});
  }

  changeAvatar = (img) => {
    this.setState({ img });
    this.props.onChange(img);
  }

  closeCropperModal = () => {
    this.cropperModal = null
    this.setState({})
  }

  render() {
    let className = "up-load-content " + this.props.className;
    return (
      <div className={className}>
        {
          // this.props.close && <Icon type="close-circle"
          //   className='close'
          //   onClick={() => {
          //     var img = this.props.basicImg || baseImg;
          //     this.setState({ img });
          //     this.props.onChange(img);
          //   }}
          // />
          <span
            className="iconfont icon"
            className='close'
            onClick={() => {
              var img = this.props.basicImg || baseImg;
              this.setState({ img });
              this.props.onChange(img);
            }}
          >&#xe836;</span>
        }
        <div className="upload"
          onClick={this.handleUpdateAvatar}
          style={{
            width: this.props.width + 'px',
            height: this.props.height + 'px',
            borderRadius: this.props.radius || '0px'
          }}>
          {this.state.img || this.props.basicImg ?<img  
            style={!this.props.onlyCenter ?
              {
                width: this.props.width + 'px',
                height: this.props.height + 'px',
                borderRadius: '50%'
              }
              : { objectFit: 'cover', width: '100%', height: '100%' }
            }
            src={this.state.img || this.props.basicImg || baseImg}
            alt="" className="avatar" />
            :
            <Avatar
              style={{
                width: this.props.width + 'px',
                height: this.props.height + 'px',
                borderRadius: this.props.radius || '0px'
              }}
              size="large" icon="user" src={baseImg} />}

          <div className='edit' style={{
            width: this.props.width + 'px',
            height: this.props.height + 'px',
            borderRadius: this.props.radius || '0px'
          }}>
            {this.props.addIcon}
          </div>
        </div>

        {this.cropperModal}
      </div>
    )
  }
}

UpLoad.propTypes = {

};

UpLoad.defaultProps = {
  className: "",
  basicImg: '',
  onChange: function () { },
  width: 40,
  height: 40,
  radius: '0px',
  onlyCenter: false,
}

export default UpLoad;