/*
 * @Author: 吴文洁
 * @Date: 2019-07-10 10:30:49
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-12-04 15:19:59
 * @Description:
 */
import React, { useContext, useEffect } from 'react';
import { withRouter} from 'react-router-dom';
import {ConfigProvider } from 'antd';
import Header from './Header'
import Menu from './Menu'
import Main from './Main'
import { Route, Switch } from 'react-router-dom'
import zhCN from 'antd/es/locale/zh_CN'
import User from '@/common/js/user';
import axios from 'axios';
import BaseService from "@/domains/basic-domain/baseService";
import { XMContext } from '@/store/context';
import { setStoreGroupPermission, setStorePermission, setStoreGroupList, setStoreList } from '@/store/actions/index';
declare var window: any;

const App: React.FC = (props: any) => {
  const ctx: any = useContext(XMContext);
  const userId = User.getUserId();

  window.ctx = ctx;

  useEffect(() => {
    getStoreAndUserInfo();
  },[userId])

  async function getStoreAndUserInfo(){
    await getStoreGroupAndStoreList();
    await getUserPermission();
  }

  function getStoreGroupAndStoreList() {
    BaseService.getUserStore({ userId }).then((res) => {
      
      const { storeGroupVOS = [], storeVOS = [] } = res.result;
      const { id, storeUserId} = storeVOS[0];

      User.setStoreId(id);
      User.setStoreUserId(storeUserId);
      ctx.dispatch(setStoreGroupList(storeGroupVOS))
      ctx.dispatch(setStoreList(storeVOS))
    });
  }

  function getUserPermission() {
    const storeId = User.getStoreId();
    const storeUserId = User.getStoreUserId();

    BaseService.getUserPermission({ storeId, storeUserId }).then((res) => {
      console.log(res.result);
      const {storePermission, storePermissionGroup, storeUserPermission, storeUserPermissionGroup } = res.result;
      ctx.dispatch(setStoreGroupPermission(storePermissionGroup))
      ctx.dispatch(setStorePermission(storeUserPermissionGroup))
    });
  }

    return (
      <div id="home">
        <Header/>
        <ConfigProvider locale={zhCN}>
          <Main/>
        </ConfigProvider>
        <Menu />
      </div>
    )
}

export default withRouter(App)
