import React from 'react';
import { Modal, Button, Radio, Tooltip } from 'antd';
import WWOpenDataCom from '@/components/WWOpenDataCom';
import './SetEmployeeModal.less'

const RadioGroup = Radio.Group;
const tagMap = {
  Cloud_Operator: '运营师',
  Cloud_Lecturer: '讲师',
  Cloud_Manager: '管理员',
}

export default class SetEmployeeModal extends React.Component {
  constructor(props) {
    super(props);
    const list = props.list.map(item => {
      item.roleCode = (props.selectObject || {})[item.userId] || (item.enterpriseRole === 'ADMIN' ? 'Cloud_Manager' : 'Cloud_Lecturer');
      return item;
    })
    const selectedData = list[0] || {};
    this.state = {
      list:this.uniqArr([...list]),
      selected: selectedData.userId,
      roleCode: selectedData.roleCode,
      submit:false
    }
  }

  uniqArr(arr){
    let obj={};
    arr.map((item,index)=>{
        // 若重复则删除该项
        if(obj.hasOwnProperty(item.userId)){
            arr.splice(index,1);
        // 不重复则存入obj
        }else{
            obj[item.userId]=item.userName;
        }
    });
    return arr;
  }

  handleChangeValues(value) {
    const { list, selected } = this.state;
    list.map((item) => {
      if (item.userId === selected) {
        item.roleCode = value;
      }
    })
    this.props.onChange(selected, value);
    this.setState({ roleCode: value, list});
  }

  render() {
    const {
      list,
      roleCode,
      selected,
      submit
    } = this.state;
    return (
      <Modal
        visible={true}
        title="添加员工"
        className="set-employee-modal"
        onCancel={() => {
          this.props.onCancel()
        }}
        width={680}
        footer={
          <div className="modal-footer">
            <Button style={{ float: 'left' }} onClick={() => this.props.onClose()}>上一步</Button>
            <Button onClick={() => this.props.onCancel()}>取消</Button>
            <Button onClick={() =>{this.setState({submit:true},()=>this.props.onOk(list))}} type="primary" disabled={submit}>确定</Button>
          </div>
        }
      >
        <div className="employee-container">
          <div className="employee-box">
            {list.map((item) => (
              <div
                className={`item ${selected === item.userId ? ' selected' : ''}`}
                key={item.userId}
                onClick={() => {
                  this.setState({ selected: item.userId, roleCode: item.roleCode })
                }}
              >
                <span className="icon iconfont avatar-icon">&#xe84a;</span>
                <Tooltip title={item.name}>
                  <span className='name'>
                    {/* {item.userName} */}
                    <WWOpenDataCom type="userName" openid={item.userName}/>
                  </span>
                </Tooltip>
                <span className="tag">{tagMap[item.roleCode]}</span>
            </div>
            ))}
          </div>
          <div className="detail-box">
            <div className="title">员工身份：</div>
            <RadioGroup
              value={roleCode}
              onChange={(e) => {
                this.handleChangeValues(e.target.value);
              }}
              className="mt5"
            >
              <Radio value={"Cloud_Operator"} className="mt-4">
                <span style={{ color: "#333" }}>运营师</span>
                <p className="radio-tip">
                  仅可查看/转发培训计划内容，并查看负责的学员学习进度
                </p>
              </Radio>
              <Radio value={"Cloud_Lecturer"} className="mt-4">
                <span style={{ color: "#333" }}>讲师</span>
                <p className="radio-tip">
                  仅可查看/使用与自己相关的文件和课表，并进行上课
                </p>
              </Radio>
              <Radio value={"Cloud_Manager"}>
                <span style={{ color: "#333" }}>管理员</span>
                <p className="radio-tip">可执行学院中所有的操作</p>
              </Radio>
            </RadioGroup>
          </div>
        </div>
      </Modal>
    )
  }
}