/*
 * @Author: 吴文洁 
 * @Date: 2020-07-17 15:49:11 
 * @Last Modified by: mikey.zhaopeng
 * @Last Modified time: 2020-11-23 22:02:49
 * @Description: 大班互动-添加/编辑直播课
 */

import React from 'react';
import { withRouter } from "react-router-dom";
import { Button, message, Modal } from 'antd';

import ShowTips from "@/components/ShowTips";
import Breadcrumbs from "@/components/Breadcrumbs";

import AddLiveBasic from './components/AddLiveBasic';
import AddLiveClass from './components/AddLiveClass';
import AddLiveIntro from './components/AddLiveIntro';
import PreviewCourseModal from './modal/PreviewCourseModal';
import LackConsumeStudentModal from './modal/LackConsumeStudentModal';
import StoreService from "@/domains/store-domain/storeService";
import moment from 'moment';

import './AddLive.less';

const defaultCover = 'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png';
const defaultBasicInfo = {
  courseName: null,  // 课程名称
  coverId: null,
  coverUrl: defaultCover,
  parentCatalogId:'',
  parentCatalogName:'',
  sonCatalogId:'',
  sonCatalogName:''
};

const defaultClassInfo = {
  teacherId: null,
  teacherName: null,
  liveDate: null,
  timeHorizonStart: null,
  timeHorizonEnd: null,
  studentList: [],   // 学员列表
  assistant: [],     // 已经选择的助教老师
  liveType: "LARGE_CLASS_LIVE",
  consumeClassTime: 30, // 累计在线时长, 默认30分钟
  consumeHourNum: 1, // 课时, 默认1课时
  calendarTime: [],
  startTime: new Date().getTime() + 300000,
  endTime: new Date().getTime() + 300000,
  applyMode: ''
};

const defaultIntroInfo = {
  needRecord: 'YES',
  liveCourseWarmMedia: {},
  // 讲师简介
  liveCourseMediaRequests: [{
    mediaType: 'TEXT',
    mediaContent: '',
    // key: editBoxKey
  }], 
}

class AddLive extends React.Component {
  constructor(props) {
    super(props);

    const id = getParameterByName("id");
    const type = getParameterByName("type");

    this.state = {
      id,
      type,
      after: false,
      isXiaomai: false,
      loading: false,
      isEdit: true,
      selectedAssistant: [], // 已经选择的助教数量

      // 直播课基本信息
      addLiveBasicInfo: {
        courseName: null,  // 课程名称
        coverId: null,
        coverUrl: defaultCover,
        parentCatalogId:'',
        sonCatalogId:'',
        courseCatalogOption:[
          {
            value: '1',
            label: 'Zhejiang',
            children: [
              {
                value: '2',
                label: 'Hangzhou',
              },
            ],
          },
          {
            value: '3',
            label: 'Jiangsu',
            children: [
              {
                value: '4',
                label: 'Nanjing',
              }
            ],
          },
        ]
      },

      // 直播课上课信息
      addLiveClassInfo: {
        teacherId: null,
        teacherName: null,
        liveDate: null,
        timeHorizonStart: null,
        timeHorizonEnd: null,
        studentList: [], // 不扣课时学员列表
        consumeStudentList: [], // 扣课时学员列表
        excludeStudentIds: [], // 已经入库的不扣课时学员
        excludeConsumeStudentIds: [], // 已经入口的扣课时学员
        assistant: [], // 已经选择的助教老师
        liveType: "LARGE_CLASS_LIVE",
        consumeClassTime: 30, // 累计在线时长, 默认30分钟
        consumeHourNum: 1, // 课时, 默认1课时
        applyMode: '',
        calendarTime: [], // 批量排课
        startTime: new Date().getTime() + 300000, // 批量开始时分
        endTime: new Date().getTime() + 300000 // 批量结束时分
      },

      // 直播课简介
      addLiveIntroInfo: {
        needRecord: 'YES',
        liveCourseWarmMedia: {},
        liveCourseMediaRequests: [{
          mediaType: 'TEXT',
          mediaContent: '',
          // key: editBoxKey
        }],
        isAutoSendReport: true
      },
    }
  }

  componentDidMount() {
    const { type } = this.state;
    if (type === 'edit') {
      this.getCourseDetail(); 
    } else {
       
    }
  }

  getCourseDetail = () => {
    let { isEdit } = this.state;
    this.setState({ loading: true });
      // axios.Apollo('public/businessLive/getCourseDetail', {
      //   liveCourseId: this.state.id
      // }).then((res) => {
      //   const {
      //     teacherId,
      //     studentIds,
      //     consumeStudentIds,
      //     courseName,
      //     coverUrl,
      //     coverId,
      //     intro,
      //     courseState,
      //     startTime,
      //     endTime,
      //     liveType,
      //     adminShowVOList,
      //     channel,
      //     podium,
      //     courseMediaVOS,
      //     nickname,
      //     needRecord,
      //     consumeHourNum,
      //     consumeClassTime,
      //     warmMedia,
      //     applyMode,
      //     autoSendReport
      //   } = res.result;
        
      //   const studentList = [];

      //   _.each(studentIds, (item) => {
      //     studentList.push({ studentId: item });
      //   });

      //   const selectedAssistant = _.map(adminShowVOList, (item) => ({
      //     id: item.adminId,
      //     adminName: item.adminName,
      //   }));

      //   const assistantId = _.pluck(adminShowVOList, "adminId");

      //   courseMediaVOS.map((item) => {
      //     item.key =  window.random_string(16);
      //     return item;
      //   })

      //   const addLiveBasicInfo = {
      //     courseName,
      //     coverId,
      //     coverUrl: coverUrl || defaultCover,
      //   };

      //   const liveDate = startTime;
      //   const timeHorizonStart = startTime;
      //   const timeHorizonEnd = endTime;
      //   const addLiveClassInfo = {
      //     liveType,
      //     liveDate,
      //     nickname,
      //     teacherId,
      //     studentList,
      //     consumeHourNum,
      //     consumeClassTime,
      //     consumeStudentList: consumeStudentIds,
      //     timeHorizonStart,
      //     timeHorizonEnd,
      //     assistant: assistantId,
      //     excludeStudentIds: studentIds,
      //     excludeConsumeStudentIds: _.pluck(consumeStudentIds, 'studentId'),
      //     applyMode
      //   }
      //   const liveCourseMediaRequests = courseMediaVOS.length
      //     ? [...courseMediaVOS]
      //     : [{ mediaType: 'TEXT', mediaContent: '', key: window.random_string(16) }, ...courseMediaVOS];
        
      //   const addLiveIntroInfo = {
      //     liveCourseWarmMedia: warmMedia,
      //     needRecord,
      //     liveCourseMediaRequests,
      //     isAutoSendReport: !!(autoSendReport === "AUTO")
      //   }
      //   // 晚于开课前30分钟
      //   if(new Date().getTime() > startTime - 1800000) {
      //     isEdit = false
      //   }
      //   this.setState({
      //     isEdit,
      //     loading: false,
      //     selectedAssistant,
      //     addLiveIntroInfo,
      //     addLiveClassInfo,
      //     addLiveBasicInfo,
      //     after: courseState !== "UN_START",
      //     isXiaomai: channel === "XIAOMAI",
      //   });
      // })
  }
  getCourseCatalogList = ()=>{
    StoreService.getCourseCatalogList({current:1,size:1000}).then((res) => {
      // let resultData = this.handleCatalogListData(res.result.records)
      // setCourseCatalogList(resultData);
      // setTotal(res.result.total);
    });
  }
  handleCatalogListData = (listData)=>{
    // listData.map((item:any,index:any) => {
    //   item.type = "parent"
    //   item.key = item.id;
    //   if(item.sonCategoryList){
    //     item.sonCategoryList.map((_item:any,_index:any) =>{
    //       _item.type = "child";
    //       _item.key=_item.id
    //       return _item
    //     });
    //   }
    //   return item
    // })
    // return listData
  }
  // 修改基本信息
  handleChangeBasicInfo = (field, value, _coverUrl) => {
    const { coverUrl } = this.state.addLiveBasicInfo;
    console.log(field,value);
    this.setState({
      addLiveBasicInfo: {
        ...this.state.addLiveBasicInfo,
        [field]: value,
        coverUrl: _coverUrl ? _coverUrl : coverUrl,
      }
    },()=>{console.log(this.state.addLiveBasicInfo)})
  }

  // 修改上课信息
  handleChangeClassInfo = (field, value, teacherList) => {
    console.log("change-----",value);
    const _value = value ? value.valueOf() : null;
    if (teacherList) {
      let selectedTeacher;
      if (field === 'teacherId') {
        selectedTeacher = _.find(teacherList, item => item.teacherId === value)
        // 判断上课老师是否已经被选为了助教老师
        const { addLiveClassInfo: { assistant } } = this.state;
        if (selectedTeacher && assistant.includes(selectedTeacher.teacherId)) {
          message.warning('上课老师和助教老师不能是同一个人');
          return;
        }
      }

      this.setState({
        addLiveClassInfo: {
          ...this.state.addLiveClassInfo,
          nickname: selectedTeacher ? selectedTeacher.teacherName: null,
          [field]: _value,
        }
      });
    } else {
      if (field === 'assistant') {
        // 判断助教老师是否已经被选为了上课老师
        const { addLiveClassInfo: { teacherId } } = this.state;
        if (_value && _value.includes(teacherId)) {
          message.warning('上课老师和助教老师不能是同一个人');
          return;
        }
      }
      this.setState({
        addLiveClassInfo: {
          ...this.state.addLiveClassInfo,
          [field]: _value,
        }
      });
    }
    // 批量开始时间改变，结束时间自动同步一致
    if (field === 'startTime') {
      this.setState({
        addLiveClassInfo: {
          ...this.state.addLiveClassInfo,
          [field]: _value,
          endTime: _value,
        }
      });
    }
  }

  // 修改简介
  handleChangeIntroInfo = (field, value) => {
    this.setState({
      addLiveIntroInfo: {
        ...this.state.addLiveIntroInfo,
        [field]: value
      }
    })
  }

   // 完成创建/编辑
  handleSubmit = () => {
    const { addLiveBasicInfo, addLiveClassInfo, addLiveIntroInfo, id, isEdit, type } = this.state;
    const {liveDate, timeHorizonStart} = addLiveClassInfo;
    const _liveDate = moment(liveDate).format("YYYY-MM-DD");
    const _timeHorizonStart = moment(timeHorizonStart).format('HH:mm');
    const startTime = moment(_liveDate + ' ' + _timeHorizonStart).format('x');
    if(type === 'edit' && isEdit && new Date().getTime() > startTime - 1800000) {
      Modal.info({
        title: "提示",
        icon: (
          <span className="icon iconfont default-confirm-icon">
            &#xe6f4;
          </span>
        ),
        content: "晚于开课前30分钟，部分信息不可修改",
        okText: '我知道了',
        onOk: () => {
          this.getCourseDetail();
        }
      });
      return
    }
    this.handleValidate(addLiveBasicInfo, addLiveClassInfo, addLiveIntroInfo, isEdit).then((res)  => {
      if (!res) return;
      const { type } = this.state;

      const { courseName, coverId, coverUrl } = addLiveBasicInfo;
      const {
        podium,
        liveType,
        liveDate,
        teacherId,
        assistant,
        studentList,
        consumeHourNum,
        timeHorizonEnd,
        consumeClassTime,
        timeHorizonStart,
        consumeStudentList,
        applyMode,
        calendarTime,
      } = addLiveClassInfo;

      let { startTime, endTime } = addLiveClassInfo;
      const { liveCourseMediaRequests, needRecord, liveCourseWarmMedia, isAutoSendReport} = addLiveIntroInfo;
      if(window.NewVersion && type === 'add') {
        startTime = startTime;
        endTime = endTime;
      } else {
        const _liveDate = moment(liveDate).format("YYYY-MM-DD");
        const _timeHorizonStart = moment(timeHorizonStart).format('HH:mm');
        const _timeHorizonEnd = moment(timeHorizonEnd).format('HH:mm');
  
        startTime = moment(_liveDate + ' ' + _timeHorizonStart).format('x');
        endTime = moment(_liveDate + ' ' + _timeHorizonEnd).format('x');
      }

      const commonParams = {
        coverId,
        startTime,
        endTime,
        teacherId,
        liveType,
        consumeHourNum,
        consumeClassTime,
        adminIds: assistant,
        courseName: courseName.trim(),
        studentIds: _.pluck(studentList, "studentId"),
        consumeStudentIds: consumeStudentList,
        liveCourseMediaRequests: liveCourseMediaRequests.filter(item => { return !!item.mediaContent; }),
        needRecord,
        liveCourseWarmMedia,
        applyMode,
        autoSendReport: isAutoSendReport ? "AUTO":"OFF_AUTO",
        calendarTime
      }
      if (type === 'add') {
        const params = {
          coverUrl,
          ...commonParams,
        }
        if(params.liveCourseWarmMedia && !params.liveCourseWarmMedia.mediaUrl) {
          delete params.liveCourseWarmMedia
        }
        axios.Apollo("public/businessLive/createCourse", params).then((res) => {
          if (!res) return;
          message.success("新建成功");
          localStorage.setItem('largeLiveCourseItem', JSON.stringify({
            ...params,
            liveCourseId: res.result
          }));

          window.RCHistory.goBack();
        });
      } else {
        const params = {
          ...commonParams,
          liveCourseId: id,
        }
        if(params.liveCourseWarmMedia && !params.liveCourseWarmMedia.mediaUrl) {
          delete params.liveCourseWarmMedia
        }
        axios.Apollo("public/businessLive/updateCourse", params).then((res) => {
          message.success("更新成功");
          this.setState({ loading: false });
          window.RCHistory.goBack();
        });
      }
    })
  }
  handleValidateLackConsumeModal = (consumeHourNum, calendarTime, consumeStudentList) => {
    return new Promise((resolve) => {
        const lackConsumeStudentList = [];
        
        consumeStudentList.forEach(item => {
          if(item.consumeHourNum < consumeHourNum * calendarTime.length) {
            lackConsumeStudentList.push(item);
          }
        })
        if(lackConsumeStudentList.length > 0) {
          const lackConsumeStudentModal = (
            <LackConsumeStudentModal
              consumeHourNum={consumeHourNum}
              calendarTime={calendarTime}
              lackConsumeStudentList={lackConsumeStudentList}
              onOk={() => {
                resolve(true);
                this.setState({
                  lackConsumeStudentModal: null
                })
                
              }}
              onClose={() => {
                resolve(false);
                this.setState({
                  lackConsumeStudentModal: null
                })
               
              }}
            />
          )
          this.setState({
            lackConsumeStudentModal
          })
        } else {
          resolve(true);
        }
    })
  }
  handleValidate = (addLiveBasicInfo, addLiveClassInfo, addLiveIntroInfo, isEdit) => {
    return new Promise((resolve) => {
      const { type } = this.state;
      // 校验基本信息（直播课名称）
      console.log("addLiveBasicInfo",addLiveBasicInfo);
      const { courseName,parentCatalogId} = addLiveBasicInfo;
      const {
        liveDate, timeHorizonStart, timeHorizonEnd, teacherId, calendarTime, consumeStudentList, consumeHourNum, consumeClassTime, applyMode
      } = addLiveClassInfo;

      const { liveCourseMediaRequests } = addLiveIntroInfo;
      const currentTime = +new Date();
      if(!courseName) {
        message.warning('请输入课程名称');
        resolve(false);
        return;
      }
      if(!parentCatalogId){
        message.warning('请选择课程分类');
        resolve(false);
        return;
      }
      const { startTime, endTime } = addLiveClassInfo;
      if(calendarTime.length === 0) {
        message.warning('请选择上课日期');
        resolve(false);
        return; 
      } else if(startTime === endTime) {
        message.warning('结束时间必须晚于开始时间');
        resolve(false);
        return; 
      }
      // 若有今日排课 校验当前时间
      const currentDay = moment(currentTime).format('YYYY-MM-DD');
      const itemToday = _.find(calendarTime, (item) => {
        const itemDay = moment(item).format('YYYY-MM-DD');
        return itemDay === currentDay;
      })
      if(itemToday) {
        const itemDay = moment(itemToday).format('YYYY-MM-DD');
        const itemHour = moment(startTime).format('HH:mm');
        if(itemDay === currentDay) {
          if(moment(itemDay + ' ' + itemHour).format('x') < currentTime) {
            message.warning('开始时间不能早于现在');
            resolve(false);
            return;
          }
        }
      }
      // if(consumeClassTime > (endTime - startTime) / 60000)  {
      //   message.warning('到课规则时长不能超过排课时长');
      //   resolve(false);
      //   return;
      // }
     
      if(!teacherId) {
        message.warning('上课老师不能为空');
        resolve(false);
        return; 
      } else if(!applyMode) { 
        message.warning('请选择分享设置');
        resolve(false);
        return;
      } else {
        const textIntro = liveCourseMediaRequests.filter(item => { return item.mediaType === 'TEXT'; });
        for (let i = 0, len = textIntro.length; i < len; i++) {
          if (textIntro[i].mediaContent && textIntro[i].mediaContentLength.length > 1000) {
            message.warning(`第${i+1}个文字简介的字数超过了1000个字`);
            resolve(false);
            return;
          }
        }  
      }
      if(window.NewVersion && type === 'add') {
        this.handleValidateLackConsumeModal(consumeHourNum, calendarTime, consumeStudentList).then(res => {  
          resolve(res)
        })
      } else {
        resolve(true);
      }
    });
  }

  // 显示预览课程弹窗
  handleShowPreviewModal = () => {
    const { addLiveBasicInfo, addLiveClassInfo, addLiveIntroInfo } = this.state;
    const previewLiveCourseModal = (
      <PreviewCourseModal
        courseBasinInfo={addLiveBasicInfo}
        courseClassInfo={addLiveClassInfo}
        courseIntroInfo={addLiveIntroInfo}
        close={() => {
          this.setState({
            previewLiveCourseModal: null
          })
        }}
      />
    );

    this.setState({ previewLiveCourseModal });
  }

  // 取消编辑并返回上一级路由
  handleGoBack = () => {
    // 比较state的addLiveBasicInfo, addLiveClassInfo, addLiveIntroInfo和默认数据是否相等
    const { addLiveBasicInfo, addLiveClassInfo, addLiveIntroInfo } = this.state;
    if (!_.isEqual(addLiveBasicInfo, defaultBasicInfo) ||
      !_.isEqual(addLiveClassInfo, defaultClassInfo) ||
      !_.isEqual(addLiveIntroInfo, defaultIntroInfo)
    ) {
      Modal.confirm({
        title: '确定要返回吗？',
        content: '返回后，本次编辑的内容将不被保存',
        okText: '确认返回',
        cancelText: '留在本页',
        icon: <span className="icon iconfont default-confirm-icon">&#xe6f4;</span>,
        onOk: () =>  {
          window.RCHistory.goBack();
        }
      })
    } else {
      // 直接返回
      
      window.RCHistory.goBack();
    }
  }

  render() {

    const {
      id, type, after, isXiaomai, selectedAssistant,
      addLiveBasicInfo, addLiveClassInfo, addLiveIntroInfo,
      isEdit
    } = this.state;

    return (
      <div className="page add-live-page">
        <Breadcrumbs
          navList={type == "add" ? "新建直播课" : "编辑直播课"}
          goBack={this.handleGoBack}
        />
        <div className="box">
          <div className="show-tips">
            <ShowTips message="请遵守国家相关规定，切勿上传低俗色情、暴力恐怖、谣言诈骗、侵权盗版等相关内容，小麦助教保有依据国家规定及平台规则进行处理的权利" />
          </div>
          <div className="add-live-page__form">
            <div className="basic-info__wrap">
              <div className="title">基本信息</div>
              <AddLiveBasic
                liveScene="large"
                isEdit={isEdit}
                data={addLiveBasicInfo}
                onChange={this.handleChangeBasicInfo}
              />
            </div>

            <div className="class-info__wrap">
              <div className="title">上课信息</div>
              <AddLiveClass
                liveScene="large"
                isEdit={isEdit}
                after={after}
                pageType={type}
                isXiaomai={isXiaomai}
                data={{...addLiveClassInfo, id} }
                selectedAssistant={selectedAssistant}
                onChange={this.handleChangeClassInfo}
              /> 
            </div>

            <div className="intro-info__wrap">
              <div className="title">更多信息</div>
              <AddLiveIntro
                liveScene="large"
                isEdit={isEdit}
                data={addLiveIntroInfo}
                isXiaomai={isXiaomai}
                onChange={this.handleChangeIntroInfo}
              />
            </div>
          </div>
        </div>

        <div className="footer">
          <Button onClick={this.handleGoBack}>取消</Button>
          <Button onClick={this.handleShowPreviewModal}>预览课程介绍</Button>
          <Button type="primary" onClick={_.debounce(() => this.handleSubmit(), 3000, true)}>保存</Button>
        </div>

        { this.state.previewLiveCourseModal }
        { this.state.lackConsumeStudentModal }
      </div>
    )
  }
}

export default withRouter(AddLive);