import React from "react";
import { withRouter } from "react-router-dom";
import {
  Table,
  Tooltip,
  Popover,
  Select,
  message,
  Modal,
  Button,
  Popconfirm,
  Spin,
  Checkbox,
} from "antd";
import dealTimeDuration from "../utils/dealTimeDuration";
import { PageControl } from "@/components";
import Bus from "@/core/bus";

import "./DataList.less";
class DataList extends React.Component {
  constructor(props) {
    super(props);
    const courseId = getParameterByName("id"); // 课程ID
    const type = getParameterByName("type"); // 来源: 大班直播 large 互动班课 interactive
    const instId = window.currentUserInstInfo.instId || LS.get("instId"); // 机构ID
    console.log("course-data");
    this.state = {
      courseId,
      type,
      instId,
      teacherData: [], // 老师上课数据
      studentData: [], // 学员上课数据
      courseInfo: {}, // 课程信息
      liveSignState: "",
      nameOrPhone: "", // 搜索学员姓名/手机号
      current: 1,
      size: 10, // 添加扣课时学员弹窗回填所需 当前接口返回全部列表
      total: 0,
      loading: false
    };
  }

  componentDidMount() {
    // this.fetchCourseInfo();
    // this.fetchTeacherData();
    // this.fetchStudentData();
  }


  // 获取课程信息
  fetchCourseInfo() {
    // axios
    //   .Apollo('public/businessLive/getCourseDetail', {
    //     liveCourseId: this.state.courseId,
    //   })
    //   .then((res) => {
    //     const { result = {} } = res;
    //     const courseInfo = result;
    //     this.setState({
    //       courseInfo,
    //     });
    //   });
  }
  // 获取学员上课数据
  fetchStudentData = (current = 1) => {
    this.setState({ loading: true });
    const { courseId, size, nameOrPhone, liveSignState } = this.state;
    const params = {
      liveCourseId: courseId,
      current,
      size,
      nameOrPhone,
      liveSignState,
    };
    if (!params.liveSignState) {
      delete params.liveSignState;
    }
    // window.axios
    //   .Apollo("public/businessLive/queryStudentVisitData", params)
    //   .then((res) => {
    //     if (res.result) {
    //       const { records = [], current, size, total } = res.result;
    //       records.forEach(item => {
    //         item.edit = false;
    //         item.courseBag = [];
    //       });
    //       this.setState({
    //         studentData: records,
    //         current,
    //         size,
    //         total,
    //         loading: false,
    //       }
    //     );
    //   }
    // });
  };
  // 获取老师上课数据
  fetchTeacherData = () => {
    // window.axios
    //   .Apollo('public/businessLive/queryTeacherVisitData', { liveCourseId: this.state.courseId })
    //   .then((res) => {
    //     if (res.result) {
    //       const teacherData = [res.result];
    //       this.setState(
    //         {
    //           teacherData,
    //         }
    //       );
    //     }
    //   });
  };

  // 进入直播次数列表
  getVisiterColumns() {
    const columns = [
      {
        title: "序号",
        dataIndex: "index",
        width: 50,
        render: (text, record, index) => {
          return <span>{index + 1}</span>;
        },
      },
      {
        title: "进入时间",
        dataIndex: "entryTime",
        width: 150,
        render: (text) => (
          <span>{formatDate("YYYY-MM-DD H:i", parseInt(text))}</span>
        ),
      },
      {
        title: "离开时间",
        dataIndex: "leaveTime",
        width: 150,
        render: (text) => (
          <span>{formatDate("YYYY-MM-DD H:i", parseInt(text))}</span>
        ),
      },
      {
        title: "在线时长",
        dataIndex: "lookingDuration",
        render: (text, record) => {
          return <span>{text ? dealTimeDuration(text) : "-"}</span>;
        },
      },
    ];
    return columns;
  }

  // 学员上课数据列表
  getStudentColumns() {
    const columns = [
      {
        title: "用户姓名",
        dataIndex: "userName",
        width: 100,
      },
      {
        title: "手机号",
        dataIndex: "phone",
        render: (text, record) => {
          const { phone, bindingWeChat } = record;
          return (
            <div>
              {phone}
              {
                <Tooltip
                  title={`${bindingWeChat ? "已绑定微信" : "未绑定微信"}`}
                >
                  <span
                    className="icon iconfont"
                    style={
                      bindingWeChat
                        ? {
                            color: "#00D20D",
                            fontSize: "16px",
                            marginLeft: 6,
                          }
                        : {
                            fontSize: "16px",
                            color: "#BFBFBF",
                            marginLeft: 6,
                          }
                    }
                  >
                    &#xe68d;
                  </span>
                </Tooltip>
              }
            </div>
          );
        },
      },
      {
        title: "观看次数",
        dataIndex: "entryNum",
        align: "right",
        render: (text, record) => {
          if (text > 0) {
            if (
              record.visitorInfoVOList &&
              record.visitorInfoVOList.length > 0
            ) {
              const table = (
                <Table
                  columns={this.getVisiterColumns()}
                  dataSource={record.visitorInfoVOList}
                  scroll={{ y: 75 }}
                  size={"small"}
                  style={{ width: 450 }}
                  pagination={false}
                />
              );
              return (
                <Popover content={table} trigger="click">
                  <span className="handel-btn">{text}</span>
                </Popover>
              );
            } else {
              return <div className="live-table--empty">暂无观看数据</div>;
            }
          } else {
            return <span>{text}</span>;
          }
        },
      },
      {
        title: "累计在线时长",
        dataIndex: "watchDuration",
        width: 150,
        sorter: (a, b) => a.watchDuration - b.watchDuration,
        sortDirections: ["descend", "ascend"],
        render: (text, record) => {
          //如无离开时间，就置空
          return <span>{text ? dealTimeDuration(text) : "00:00:00"}</span>;
        },
      },
    ];

    return columns;
  }
  // 学员导出5.0
  handleExportV5 = () => {
    const { type, courseId } = this.state;
    const url =
      type === "large"
        ? "public/businessLive/exportLargeClassLiveAsync"
        : "public/businessLive/exportClassInteractionLiveSync";
    // window.axios
    //   .Apollo(url, {
    //     liveCourseId: courseId,
    //     exportLiveType: 'VISITOR',
    //   })
    //   .then((res) => {
    //     Bus.trigger('get_download_count');
    //     Modal.success({
    //       title: '导出任务提交成功',
    //       content: '请前往右上角的“任务中心”进行下载',
    //       okText: '我知道了',
    //     });
    //   });
  };

  handleCheckEnterTimes = () => {
    const { teacherData } = this.state;
    if (teacherData.times > 0) {
      if (
        teacherData.visitorInfoVOList &&
        teacherData.visitorInfoVOList.length > 0
      ) {
        const table = (
          <Table
            columns={this.getVisiterColumns()}
            dataSource={teacherData.visitorInfoVOList}
            scroll={{ y: 75 }}
            size={"small"}
            style={{ width: 450 }}
            pagination={false}
          />
        );
        return (
          <Popover content={table} trigger="click">
            <span className="handel-btn">{text}</span>
          </Popover>
        );
      } else {
        return <div className="live-table--empty">暂无观看数据</div>;
      }
    } else {
      return <span>{teacherData.times}</span>;
    }
  };

  render() {
    const {
      teacherData,
      studentData,
      current,
      size,
      total,
      loading,
    } = this.state;
    return (
      <Spin spinning={loading}>
        {/* 讲师上课数据 */}
        <div className="courseData-teacher">
          <p className="title">讲师上课数据</p>
          <div className="teacher-course-data">
            <div className="avatar-name-phone item-block">
              <img
                src={
                  teacherData.avatar ||
                  "https://image.xiaomaiketang.com/xm/rJeQaZxtc7.png"
                }
                alt=""
                className="avatar"
              />
              <div className="right">
                <div className="name">{teacherData.name || "王凯凯"}</div>
                <div className="phone">
                  {teacherData.phone || "13888884388"}
                </div>
              </div>
            </div>

            <div className="times item-block">
              <div
                className={`times-num ${
                  Number(teacherData.times) > 0 ? "can-click" : ""
                }`}
                onClick={() => {
                  this.handleCheckEnterTimes();
                }}
              >
                {teacherData.times || "47"}
              </div>
              <div className="text">进入直播间次数</div>
            </div>

            <div className="online-duration item-block">
              <div className="duration">
                {dealTimeDuration(teacherData.duration) || "20:30:45"}
              </div>
              <div className="text">累计在线时长</div>
            </div>
          </div>
        </div>

        {/* 用户上课数据 */}
        <div className="courseData-student">
          <p className="title">用户上课数据</p>
          <div className="filter-wrap">
            <div className="filter">
              <Button
                style={{ height: 32, marginLeft: 16 }}
                onClick={_.debounce(
                  () => {
                    if (!studentData.length) {
                      message.warning("暂无数据可导出");
                      return;
                    }
                    this.handleExportV5();
                  },
                  500,
                  true
                )}
              >
                导出
              </Button>
            </div>
          </div>

          <Table
            size="small"
            scroll={{ y: 600 }}
            columns={this.getStudentColumns()}
            dataSource={studentData}
            pagination={false}
            style={{ margin: "16px 0" }}
          />

          <PageControl
            size="small"
            current={current - 1}
            pageSize={size}
            total={total}
            toPage={(page) => {
              this.fetchStudentData(page + 1);
            }}
          />
        </div>
      </Spin>
    );
  }
}

export default withRouter(DataList);
