/*
 * @Description:
 * @Author: zangsuyun
 * @Date: 2021-03-12 10:43:10
 * @LastEditors: zangsuyun
 * @LastEditTime: 2021-04-07 13:50:11
 * @Copyright: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from "react";

import KnowledgeBaseFilter from "./components/KnowledgeBaseFilter";
import KnowledgeBaseOpt from "./components/KnowledgeBaseOpt";
import KnowledgeBaseList from "./components/KnowledgeBaseList";
import Classification from "./components/Classification";

import KnowledgeAPI from "@/data-source/knowledge/request-api";
import User from "@/common/js/user";

export default class KnowledgeBase extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      query: {
        size: 10,
        current: 1,
        storeId: User.getStoreId(),
        categoryId: 0,
      },
      dataSource: [], // 知识库列表
      totalCount: 0, // 知识库数据总条数
      categoryId: '0',
      updateCategoryFlag: false,
    };
  }

  componentWillMount() {
    // 获取知识库列表
    this.handleFetchScheduleList();
    // this.getCategoryTree()
  }
  getSelectedCategoryId = (categoryId) => {
    this.setState({
      categoryId,
    });
    this.handleFetchScheduleList({ categoryId,current:1 });
  };

  // 更新分类树
  updateCategoryTree = () => {
    this.setState({
      updateCategoryFlag: !this.state.updateCategoryFlag,
    });
  };
  // 获取知识库列表
  handleFetchScheduleList = (_query = {}) => {
    const query = {
      ...this.state.query,
      ..._query,
    };

    // 更新请求参数
    this.setState({ query });

    KnowledgeAPI.queryPageKnowledgeForManager(query).then((res) => {
      // KnowledgeAPI.videoSchedulePage(query).then((res) => {
      const { result = {} } = res || {};
      const { records = [], total = 0 } = result;
      this.setState({
        dataSource: records,
        totalCount: Number(total),
      });
    });
  };

  render() {
    const {
      dataSource,
      totalCount,
      query,
      categoryId,
      updateCategoryFlag,
    } = this.state;
    return (
      <div className="page">
        <div className="content-header">知识库</div>

        <div className="box" style={{ display: "flex" }}>
          {/* 搜索模块 */}
          <div className="left" style={{ width: 245 }}>
            <Classification
              updateCategoryFlag={updateCategoryFlag}
              categoryId={categoryId}
              getSelectedCategoryId={this.getSelectedCategoryId}
            />
          </div>
          <div
            className="liner"
            style={{ backgroundColor: "#ddd", width: 1, margin: "1px 20px" }}
          ></div>
          <div className="right" style={{ width: "calc(100% - 285px)" }}>
            <KnowledgeBaseFilter onChange={this.handleFetchScheduleList} />

            {/* 操作模块 */}
            {categoryId != 0 && <KnowledgeBaseOpt
              onChange={this.handleFetchScheduleList}
              updateCategoryTree={this.updateCategoryTree}
              categoryId={categoryId}
            />}

            {/* 知识库列表模块 */}
            <KnowledgeBaseList
              query={query}
              categoryId={categoryId}
              dataSource={dataSource}
              totalCount={totalCount}
              onChange={this.handleFetchScheduleList}
              updateCategoryTree={this.updateCategoryTree}
            />
          </div>
        </div>
      </div>
    );
  }
}
