import CourseService from "@/domains/course-domain/CourseService";
import React from "react";
import './LearningDetailModal.less';


class LearningDetailModal extends React.Component {
    constructor(props) {
      super(props);
      this.state = {
        data:[]
      };
    }

    componentDidMount() {
        this.handleFetchDataList();
    }
    
      // 获取观看视频数据列表
      handleFetchDataList = () => {
        const { query, id } = this.state;
    
        const params = {
          ...query,
          courseId: id,
          storeId: User.getStoreId(),
        };
        CourseService.videoWatchInfo(params).then((res) => {
          const { result = {} } = res;
          const { records = [], total = 0 } = result;
          this.setState({
            dataSource: records,
            totalCount: Number(total),
          });
        });
      };

      
    }

    export default LearningDetailModal;