import User from "@/common/js/user";
import college from "@/common/lottie/college";
import { PageControl, XMTable } from "@/components";
import Breadcrumbs from "@/components/Breadcrumbs";
import CourseService from "@/domains/course-domain/CourseService";
import { Input, Select } from "antd";
import React from "react";
import { withRouter } from "react-router-dom";
import LearningDetailModal from "./LearningDetailModal";
import "./WatchData.less";
const { Search } = Input;

class WatchData extends React.Component {
  constructor(props) {
    super(props);
    const id = window.getParameterByName("id");
    const courseName = window.getParameterByName("courseName");

    this.state = {
      courseName,
      id,
      visible: true,
      dataSource: [],
      query: {
        current: 1,
        size: 10,
        sourceEnum: null,
      },
      totalCount: 0,
      learningDetailModal: null,
    };
  }

  componentDidMount() {
    this.handleFetchDataList();
  }

  // 获取观看视频数据列表
  handleFetchDataList = () => {
    const { query, id } = this.state;

    const params = {
      ...query,
      courseId: id,
      storeId: User.getStoreId(),
    };
    CourseService.videoWatchInfo(params).then((res) => {
      const { result = {} } = res;
      const { records = [], total = 0 } = result;
      this.setState({
        dataSource: records,
        totalCount: Number(total),
      });
    });
  };

  parseColumns = () => {
    const SOURCENUM = {
      WE_CHAT: "微信",
      WORK_WE_CHAT: "企业微信",
    };
    const columns = [
      {
        title: "观看学员",
        key: "name",
        dataIndex: "name",
        render: (val, item) => {
          return (
            <div className="watcher">
              <div className="watcher__name">{val}</div>
              <div className={`watcher__type ${item.sourceEnum}`}>
                @{SOURCENUM[item.sourceEnum]}
              </div>
            </div>
          );
        },
      },
      {
        title: "手机号",
        key: "phone",
        dataIndex: "phone",
      },
      {
        title: "首次观看时间",
        key: "firstWatch",
        dataIndex: "firstWatch",
        render: (val) => {
          return formatDate("YYYY-MM-DD H:i", val);
        },
      },
      {
        title: "学习进度",
        key: "progress",
        dataIndex: "progress",
        render: (val) => {
          return <span>{val}%</span>;
        },
      },
      {
        title: "操作",
        key: "operate",
        dataIndex: "operate",
        render: (val, record) => {
          return (
            <div className="operate">
              <div
                className="operate__item"
                onClick={() => this.ShowLearningDetailModal(record)}
              >
                学习详情
              </div>
            </div>
          );
        },
      },
    ];

    return columns;
  };

  // 显示学员数据详情弹窗
  ShowLearningDetailModal = (item) => {
    const learningDetailModal = (
      <LearningDetailModal
        data={item}
        title="学习详情"
        close={() => {
          this.setState({
            learningDetailModal: null,
          });
        }}
      />
    );
    this.setState({ learningDetailModal });
  };

  // 搜索学员姓名或手机号
  handleChangNickname = (value) => {
    const isPhone = (value || "").match(/^\d+$/);
    const { query } = this.state;
    let _query = { ...query };
    if (isPhone) {
      _query.phone = value;
      _query.nickName = null;
    } else {
      _query.nickName = value;
      _query.phone = null;
    }
    _query.current = 1;
    this.setState(
      {
        query: _query,
      },
      this.handleFetchDataList
    );
  };


  // 搜索学员类型
  handleWatchTypeSelect = (sourceEnum) => {
    const { query } = this.state;
    let _query = { ...query };
    _query.sourceEnum = sourceEnum;
    this.setState(
      {
        query: _query,
      },
      this.handleFetchDataList
    );
  };

  render() {
    const { dataSource, totalCount, query, courseName } = this.state;
    const { current, size, sourceEnum } = query;

    return (
      <div className="page video-course-watch-data">
        <Breadcrumbs
          navList="观看学员数据"
          goBack={() => {
            window.RCHistory.goBack();
          }}
        />

        <div className="box">
          <div className="box-header">
            <div className="course-detail">
              <div className="detail__line"></div>
              <div className="detail__name">{courseName}</div>
            </div>
            <div className="filter-box">
              <div className="watcher-name">
                <span className="label">学员：</span>
                <Search
                  placeholder="搜索学员姓名/手机号"
                  style={{ width: 200 }}
                  onChange={(e) => {
                    this.handleChangNickname(e.target.value);
                  }}
                  onSearch={() => {
                    this.handleFetchDataList();
                  }}
                  enterButton={<span className="icon iconfont">&#xe832;</span>}
                />
              </div>

              <div className="watch-type">
                <span className="label">学员类型：</span>
                <Select
                  showSearch
                  style={{ width: 200 }}
                  allowClear
                  onPopupScroll={this.handleFetchMore}
                  placeholder="请选择学员类型"
                  value={sourceEnum}
                  onChange={this.handleWatchTypeSelect}
                >
                  <Select.Option tyle={{ textAlign: "center" }} value="WE_CHAT">
                    微信
                  </Select.Option>
                  <Select.Option
                    tyle={{ textAlign: "center" }}
                    value="WORK_WE_CHAT"
                  >
                    企业微信
                  </Select.Option>
                </Select>
              </div>
            </div>
          </div>

          <XMTable
            renderEmpty={{
              image: college,
              description: "暂无数据",
            }}
            rowKey={(record) => record.id}
            dataSource={dataSource}
            columns={this.parseColumns()}
            pagination={false}
            bordered
            className="video-list-table"
          />

          <div className="box-footer">
            <PageControl
              current={current - 1}
              pageSize={size}
              total={totalCount}
              toPage={(page) => {
                const _query = { ...query, current: page + 1 };
                this.setState(
                  {
                    query: _query,
                  },
                  () => {
                    this.handleFetchDataList();
                  }
                );
              }}
            />
          </div>
        </div>
      </div>
    );
  }
}

export default withRouter(WatchData);
