import React, { useState, useRef, useEffect, useContext } from 'react'
import moment from 'moment';
import { Modal } from 'antd';
import './PreviewModal.less'

function PreviewModal(props: any) {
    console.log(props.info)
    const resultContentEnum = {
        PASS_AND_SCORE: '显示考试分数和是否及格',
        ONLY_SCORE: '仅显示考试分数',
        ONLY_PASS: '仅显示是否及格'
    }
    const answerAnalysisEnum = {
        ANALYSE_AND_RIGHT_OR_WRONG: '显示对错与解析',
        RIGHT_OR_WRONG: '仅显示对错',
        CAN_NOT_CHECK: '都不显示'
    }

    return <Modal
        title="预览"
        onCancel={props.onClose}
        onOk={props.onClose}
        maskClosable={true}
        visible={true}
        footer={null}
        className='ExamPreviewModal'
        closable={true}
        width={800}

    >
        <div className="ExamPreview">
            <div className="left">
                <div className="phone">
                    <div className="content">
                        <div className="topContent">
                            <div className="title" style={{ fontSize: props.info.examName.length > 24 ? 13 : 22 ,marginTop: 20 }}>{(props.info.examName.length > 40 ? props.info.examName.substring(0, 40) : props.info.examName) || ' '}</div>
                            {
                                props.info.examStartTime && <div className="time">{moment(props.info.examStartTime).format("YYYY-MM-DD HH:mm")}~{moment(props.info.examEndTime).format("YYYY-MM-DD HH:mm")}</div>
                            }

                            <div className="rule">
                                <div className="item">
                                    <div className="num">{props.info.totalScore  || props.info.examPaper.totalScore || 0}</div>
                                    <div className="text">总分 <span className="dw" style={{color:'#999'}}>(分)</span></div>
                                </div>
                                <div className="item">
                                    <div className="num">{props.info.examTotal  || props.info.examPaper.questionCnt || 0}</div>
                                    <div className="text">总题数<span className="dw" style={{color:'#999'}} >(道)</span></div>
                                </div>
                                <div className="item">
                                    <div className="num">{props.info.passScore || 0}</div>
                                    <div className="text">及格分<span className="dw" style={{color:'#999'}} >(分)</span></div>
                                </div>
                                <div className="item">
                                    <div className="num">{props.info.examDuration || 60}</div>
                                    <div className="text">时长<span className="dw" style={{color:'#999'}} >(分钟)</span></div>
                                </div>

                            </div>
                        </div>
                        <div className="fg">
                            <img src="https://image.xiaomaiketang.com/xm/8ASbb6TQ6Q.png" alt="" />
                        </div>
                        <div className="examDesc"  style={{color:'#666'}} dangerouslySetInnerHTML={{ __html: props.info.examDesc }}></div>
                    </div>
                </div>
            </div>
            <div className="right">
                <div className="title">本次考试设置</div>
                <div className="rule">
                    <div className="item">
                        <span className="name"> 身份证验证: </span>
                        <span className="text">{props.info.needPhone == 'NEED_PHONE_VERIFY' ? '需要验证手机号才能参加考试' : '仅需微信/企业微信授权登录验证'}</span>
                    </div>
                    <div className="item" style={{marginBottom:18}}>
                        <span className="name">  选择乱序: </span>
                        <span className="text">{props.info.needOptionDisorder == 'OPTION_RANDOM' ? '选择题的选项随机排序' : '选择题按题目原有顺序展示'}</span>
                    </div>
                    <div className="item">
                        <span className="name">   考试结果查看: </span>
                        <span className="text">{props.info.resultShow === 'IMMEDIATELY' ? '交卷后立即显示考试结果' : '到达考试截止日期才显示结果'}</span>
                    </div>
                    <div className="item">
                        <span className="name">  考试结果内容: </span>
                        <span className="text">{(resultContentEnum as any)[props.info.resultContent]}</span>
                    </div>
                    <div className="item">
                        <span className="name">  答案与解析: </span>
                        <span className="text">{(answerAnalysisEnum as any)[props.info.answerAnalysis]}</span>
                    </div>

                </div>
            </div>
        </div>
    </Modal>
}

export default PreviewModal